/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.functional.xml;

import java.io.StringWriter;
import java.util.function.Function;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class SerializeXml
implements Function<Node, String> {
    private TransformerFactory transformerFactory;
    private Transformer transformer;

    public SerializeXml(TransformerFactory tf) {
        this.transformerFactory = tf;
        try {
            this.transformer = this.transformerFactory.newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String apply(Node arg) {
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(arg);
        try {
            this.transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    public TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }
}

