package eu.dnetlib.enabling.inspector;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;



/**
 * Common stuff for the inspector controllers.
 * 
 * @author marko
 * 
 */
public abstract class AbstractInspectorController { // NOPMD
	/**
	 * entry point groups
	 */
	@Autowired
	List<EntryPointDescriptorGroup> entryPointsGroups;

	/**
	 * sort entry point groups according to the group name.
	 */
	@PostConstruct
	public void sortEntryPointGroups() {
		Collections.sort(entryPointsGroups, (o1, o2) -> o1.getName().compareTo(o2.getName()));
	}

	/**
	 * common base url for all inspector pages.
	 * 
	 * @param request
	 *            http request
	 * @return base url
	 */
	@ModelAttribute("baseUrl")
	public String baseUrl(final HttpServletRequest request) {
		return request.getContextPath() + "/mvc/inspector";
	}

	@ModelAttribute("entryPointGroups")
	public List<EntryPointDescriptorGroup> entryPointGroups() {
		return entryPointsGroups;
	}
	/**
	 * Obtain a list of entry points, ordered by groups.
	 * 
	 * @return
	 */
	@ModelAttribute("entryPoints")
	public <R> List<EntryPointDescriptorModel> entryPoints(final HttpServletRequest request) {
		final String currentRelativeUrl = request.getPathInfo().replaceAll("/inspector/(.*\\.do).*", "$1");

		return entryPointGroups().stream()
				.flatMap(
						group -> group.getDescriptors().stream()
								.map(it ->
										generateEntryPointDescriptorModel(it, currentRelativeUrl)))
				.collect(Collectors.toList());
	}

	private EntryPointDescriptorModel generateEntryPointDescriptorModel(final EntryPointDescriptor it, final String currentRelativeUrl) {
		return new EntryPointDescriptorModel(it.getName(), it.getRelativeUrl(), currentRelativeUrl.equals(it.getRelativeUrl()),
				it.isHiddenAsDefault());
	}



}
