/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools.blackboard;

import eu.dnetlib.enabling.tools.blackboard.AbstractBlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobListener;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobRegistry;
import java.util.HashMap;
import java.util.Map;

public class BlackboardNotificationHandler<T extends BlackboardHandler>
extends AbstractBlackboardNotificationHandler<T>
implements BlackboardJobRegistry {
    private Map<String, BlackboardJobListener> listeners = new HashMap<String, BlackboardJobListener>();

    @Override
    protected void processJob(BlackboardJob job) {
        BlackboardJobListener listener = this.listeners.get(job.getId());
        if (listener != null) {
            if (job.isCompleted()) {
                this.listeners.remove(job.getId());
            }
            listener.processJob(job);
        }
    }

    @Override
    public void registerJobListener(BlackboardJob job, BlackboardJobListener listener) {
        this.listeners.put(job.getId(), listener);
    }

    public Map<String, BlackboardJobListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(Map<String, BlackboardJobListener> listeners) {
        this.listeners = listeners;
    }
}

