package eu.dnetlib.rmi.enabling;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import eu.dnetlib.rmi.common.BaseService;

/**
 * Like a HostingNodeManager, but any webapp (web context) can have its own.
 * <p>
 * useful for dispatching notifications shared by all the services local to a single context.
 * </p>
 *
 * @author marko
 * @author antonis
 */
@WebService(targetNamespace = "http://services.dnetlib.eu/")
public interface HostingContextManagerService extends BaseService {

	@WebMethod(operationName = "echo")
	public String echo(@WebParam(name = "message") String message);
}
