package eu.dnetlib.utils;


public class MetadataReferenceFactory {

	public static MetadataReference getMetadata(final String format, final String layout, final String interpretation) {
		return new MetadataReference(format, layout, interpretation);
	}

	public static MetadataReference decodeMetadata(final String encoded) {
		String[] split = encoded.split("-");
		if (split.length == 3) return getMetadata(split[0], split[1], split[2]);

		throw new IllegalStateException("malformed metadata reference: " + encoded);
	}

	public static MetadataReference decode(final String encoded, String mdref_separator_value) {
		String[] split = encoded.split(mdref_separator_value);
		if (split.length == 3) return getMetadata(split[0], split[1], split[2]);

		throw new IllegalStateException("malformed metadata reference: " + encoded);
	}
}
