/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.rmi.data.hadoop.actionmanager.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.rmi.data.hadoop.actionmanager.ActionManagerConstants;
import eu.dnetlib.rmi.data.hadoop.actionmanager.Agent;
import eu.dnetlib.rmi.data.hadoop.actionmanager.Operation;
import eu.dnetlib.rmi.data.hadoop.actionmanager.Provenance;
import eu.dnetlib.rmi.data.hadoop.actionmanager.actions.AbstractAction;
import eu.dnetlib.rmi.data.hadoop.actionmanager.actions.ActionFactory;
import eu.dnetlib.rmi.data.hadoop.actionmanager.actions.AtomicAction;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;

public class XsltInfoPackageAction
extends AbstractAction {
    private static final Log log = LogFactory.getLog(XsltInfoPackageAction.class);
    private Operation operation;
    private String infoPackage;
    private Provenance provenance;
    private String nsprefix;
    private String trust;
    private ActionFactory actionFactory;
    private Transformer transformer;

    public XsltInfoPackageAction(String rawSet, Agent agent, Operation operation, String infoPackage, Provenance provenance, String nsprefix, String trust, Transformer transformer, ActionFactory actionFactory) {
        super(ActionManagerConstants.ACTION_TYPE.pkg, rawSet, agent);
        this.transformer = transformer;
        this.operation = operation;
        this.infoPackage = infoPackage;
        this.provenance = provenance;
        this.nsprefix = nsprefix;
        this.trust = trust;
        this.actionFactory = actionFactory;
        this.transformer = transformer;
    }

    public List<AtomicAction> asAtomicActions() throws TransformerException, DocumentException {
        return Lists.newArrayList((Iterable)Iterables.filter(this.calculateAtomicActions(), (Predicate)new Predicate<AtomicAction>(){

            public boolean apply(AtomicAction action) {
                return action != null && action.isValid();
            }
        }));
    }

    private Document applyXslt(String xml, Provenance provenance, String trust, String nsprefix) throws DocumentException, TransformerException {
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        DocumentResult result = new DocumentResult();
        this.transformer.setParameter("trust", trust);
        this.transformer.setParameter("provenance", provenance.toString());
        this.transformer.setParameter("namespaceprefix", nsprefix);
        this.transformer.transform((Source)new DocumentSource(doc), (Result)result);
        return result.getDocument();
    }

    public List<AtomicAction> calculateAtomicActions() throws TransformerException, DocumentException {
        ArrayList list = Lists.newArrayList();
        Document doc = this.applyXslt(this.getInfoPackage(), this.provenance, this.trust, this.nsprefix);
        for (Object o : doc.selectNodes("//ACTION")) {
            list.add(this.createAtomicAction((Element)o));
        }
        return list;
    }

    private AtomicAction createAtomicAction(Element elem) {
        String key = elem.valueOf("./@targetKey");
        String colFamily = elem.valueOf("./@targetColumnFamily");
        String col = elem.valueOf("./@targetColumn");
        String value64 = elem.getTextTrim();
        byte[] value = value64.isEmpty() ? null : Base64.decodeBase64((String)value64);
        return this.getActionFactory().createAtomicAction(this.getRawSet(), this.getAgent(), key, colFamily, col, value);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    public void setActionFactory(ActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    protected byte[] getBytesContent(String content) {
        return content.getBytes();
    }

    public String getInfoPackage() {
        return this.infoPackage;
    }

    public void setInfoPackage(String infoPackage) {
        this.infoPackage = infoPackage;
    }

    public Provenance getProvenance() {
        return this.provenance;
    }

    public void setProvenance(Provenance provenance) {
        this.provenance = provenance;
    }

    public String getTrust() {
        return this.trust;
    }

    public void setTrust(String trust) {
        this.trust = trust;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public String getNsprefix() {
        return this.nsprefix;
    }

    public void setNsprefix(String nsprefix) {
        this.nsprefix = nsprefix;
    }
}

