/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.datasources;

import eu.dnetlib.enabling.datasources.IfaceDescToNode;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.rmi.datasource.DatasourceDesc;
import eu.dnetlib.rmi.datasource.IfaceDesc;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DatasourceDescToProfile
implements Function<DatasourceDesc, String> {
    private static final Log log = LogFactory.getLog(DatasourceDescToProfile.class);

    public static String convert(DatasourceDesc ds) throws Exception {
        Element root = DocumentHelper.createElement((String)"RESOURCE_PROFILE");
        Element header = root.addElement("HEADER");
        header.addElement("RESOURCE_IDENTIFIER").addAttribute("value", "");
        header.addElement("RESOURCE_TYPE").addAttribute("value", "RepositoryServiceResourceType");
        header.addElement("RESOURCE_KIND").addAttribute("value", "RepositoryServiceResources");
        header.addElement("RESOURCE_URI").addAttribute("value", "");
        header.addElement("DATE_OF_CREATION").addAttribute("value", DateUtils.now_ISO8601());
        header.addElement("PROTOCOL");
        Element body = root.addElement("BODY");
        Element conf = body.addElement("CONFIGURATION");
        conf.addElement("DATASOURCE_TYPE").setText(ds.getDatasourceClass());
        Element origId = conf.addElement("DATASOURCE_ORIGINAL_ID");
        origId.addAttribute("provenance", "D-NET");
        origId.setText(ds.getId());
        conf.addElement("DATASOURCE_AGGREGATED").setText("false");
        conf.addElement("ENVIRONMENTS");
        conf.addElement("TYPOLOGY").setText(ds.getTypology());
        conf.addElement("MAX_SIZE_OF_DATASTRUCTURE").setText("0");
        conf.addElement("AVAILABLE_DISKSPACE").setText("0");
        conf.addElement("MAX_NUMBER_OF_DATASTRUCTURE").setText("0");
        conf.addElement("OFFICIAL_NAME").setText(ds.getOfficialName());
        conf.addElement("ENGLISH_NAME").setText(ds.getEnglishName());
        conf.addElement("ICON_URI").setText(ds.getLogoUrl());
        conf.addElement("COUNTRY").setText(ds.getCountryCode());
        Element location = conf.addElement("LOCATION");
        location.addElement("LONGITUDE").setText("" + ds.getLongitude());
        location.addElement("LATITUDE").setText("" + ds.getLatitude());
        location.addElement("TIMEZONE").setText("" + ds.getTimezone());
        conf.addElement("REPOSITORY_WEBPAGE").setText(ds.getWebsiteUrl());
        conf.addElement("REPOSITORY_INSTITUTION").setText(ds.getOrganization());
        conf.addElement("ADMIN_INFO").setText(ds.getContactEmail());
        Element ifaces = conf.addElement("INTERFACES");
        for (IfaceDesc ifc : ds.getInterfaces()) {
            ifaces.add(IfaceDescToNode.convert(ifc));
        }
        Element extraFields = conf.addElement("EXTRA_FIELDS");
        DatasourceDescToProfile.addExtraField(extraFields, "ACTIVATION_ID", ds.getActivationId());
        DatasourceDescToProfile.addExtraField(extraFields, "NamespacePrefix", ds.getNamespacePrefix());
        DatasourceDescToProfile.addExtraField(extraFields, "aggregatorName", ds.getAggregator());
        DatasourceDescToProfile.addExtraField(extraFields, "dateOfCollection", "" + ds.getDateOfCollection());
        DatasourceDescToProfile.addExtraField(extraFields, "dateOfValidation", "" + ds.getDateOfValidation());
        conf.addElement("REGISTERED_BY");
        Element status = body.addElement("STATUS");
        status.addElement("NUMBER_OF_OBJECTS").setText("0");
        status.addElement("LAST_UPDATE").addAttribute("value", "");
        Element qos = body.addElement("QOS");
        qos.addElement("AVAILABILITY").setText("0");
        qos.addElement("CAPACITY");
        qos.addElement("THROUGHPUT").setText("0");
        body.addElement("SECURITY_PARAMETERS");
        body.addElement("BLACKBOARD");
        return root.asXML();
    }

    private static void addExtraField(Element extraFields, String field, String value) {
        Element f = extraFields.addElement("FIELD");
        f.addElement("key").setText(field);
        f.addElement("value").setText(value);
    }

    @Override
    public String apply(DatasourceDesc ds) {
        try {
            return DatasourceDescToProfile.convert(ds);
        }
        catch (Exception e) {
            log.error((Object)"Error convering profile", (Throwable)e);
            return null;
        }
    }
}

