/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset.factory;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.listener.IterableResultSetListener;
import eu.dnetlib.enabling.resultset.listener.ResultSetListener;
import eu.dnetlib.enabling.resultset.registry.ResultSetRegistry;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.rmi.common.ResultSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class ResultSetFactory {
    private ResultSetRegistry resultSetRegistry;
    private ResultSetClient resultSetClient;
    private String baseUrl;

    public <T> ResultSet<T> registerResultSet(ResultSetListener<T> rs) {
        String rsId = this.resultSetRegistry.registerResultSet(rs);
        return new ResultSet(rsId, this.baseUrl);
    }

    public <T> ResultSet<T> createResultSet(ResultSetListener<T> listener) {
        return this.registerResultSet(listener);
    }

    public <T> ResultSet<T> createResultSet(Iterable<T> iter) {
        return this.registerResultSet(new IterableResultSetListener<T>(iter));
    }

    public <T, K> ResultSet<K> map(ResultSet<?> rsIn, Class<T> clazzIn, Function<T, K> mapper) {
        Iterable iterIn = this.resultSetClient.iter(rsIn, clazzIn);
        return this.createResultSet(() -> StreamSupport.stream(iterIn.spliterator(), false).map(mapper).iterator());
    }

    public ResultSet<String> xsltMap(ResultSet<?> rsIn, String xslt) {
        return this.map(rsIn, (Class)String.class, (Function)new ApplyXslt(xslt));
    }

    public ResultSet<String> xsltMap(ResultSet<?> rsIn, String xslt, Map<String, String> params) {
        return this.map(rsIn, (Class)String.class, (Function)new ApplyXslt(xslt, null, params));
    }

    public ResultSet<String> xsltMap(ResultSet<?> rsIn, Resource xsltResource) {
        return this.map(rsIn, (Class)String.class, (Function)new ApplyXslt(xsltResource));
    }

    public ResultSet<String> xsltMap(ResultSet<?> rsIn, Resource xsltResource, Map<String, String> params) {
        return this.map(rsIn, (Class)String.class, (Function)new ApplyXslt(xsltResource, params));
    }

    public ResultSet<String> xsltMap(ResultSet<?> rsIn, DOMSource domSource) {
        return this.map(rsIn, (Class)String.class, (Function)new ApplyXslt((Source)domSource));
    }

    public ResultSetRegistry getResultSetRegistry() {
        return this.resultSetRegistry;
    }

    @Required
    public void setResultSetRegistry(ResultSetRegistry resultSetRegistry) {
        this.resultSetRegistry = resultSetRegistry;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Required
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public ResultSetClient getResultSetClient() {
        return this.resultSetClient;
    }

    @Required
    public void setResultSetClient(ResultSetClient resultSetClient) {
        this.resultSetClient = resultSetClient;
    }
}

