package eu.dnetlib.enabling.resultset.client;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.rmi.common.ResultSetException;

public abstract class AbstractResultSetClientIterator<T> implements Iterator<T> {

	private static final Log log = LogFactory.getLog(AbstractResultSetClientIterator.class);

	private final Queue<T> buffer = new LinkedList<T>();

	@Override
	public boolean hasNext() {
		if (!this.buffer.isEmpty()) { return true; }
		try {
			return refillBuffer();
		} catch (final ResultSetException e) {
			log.error("Error refilling resultSet buffer", e);
			throw new RuntimeException("Error refilling resultSet buffer", e);
		}
	}

	@Override
	public T next() {
		if (!hasNext()) {
			log.error("NoSuchElementException");
			throw new NoSuchElementException();
		}
		return this.buffer.poll();
	}

	@Override
	public void remove() {
		throw new RuntimeException("Not implemented");
	}

	private boolean refillBuffer() throws ResultSetException {
		final List<T> page = nextPage();
		if (page == null || page.isEmpty()) { return false; }
		this.buffer.addAll(page);
		return true;
	}

	abstract protected List<T> nextPage() throws ResultSetException;

}
