package eu.dnetlib.enabling.resultset.client;

import java.util.ArrayList;
import java.util.List;

import eu.dnetlib.enabling.resultset.listener.ResultSetListener;
import eu.dnetlib.rmi.common.ResultSetException;

public class LocalResultSetClientIterator<T> extends AbstractResultSetClientIterator<T> {

	private static final int PAGE_SIZE = 20;

	private final ResultSetListener<?> listener;
	private final Class<T> clazz;

	public LocalResultSetClientIterator(final ResultSetListener<?> listener, final Class<T> clazz) {
		super();
		this.listener = listener;
		this.clazz = clazz;
	}

	@Override
	protected List<T> nextPage() throws ResultSetException {
		final List<T> res = new ArrayList<>();
		for (int i = 0; i < PAGE_SIZE && this.listener.hasNext(); i++) {
			res.add(this.clazz.cast(this.listener.next()));
		}
		return res;
	}

}
