/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset;

import com.google.gson.Gson;
import eu.dnetlib.enabling.resultset.ResultSetInfo;
import eu.dnetlib.enabling.resultset.ResultSetResponse;
import eu.dnetlib.enabling.resultset.listener.ResultSetListener;
import eu.dnetlib.enabling.resultset.registry.ResultSetRegistry;
import eu.dnetlib.rmi.common.ResultSetException;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ResultSetController {
    @Autowired
    private ResultSetRegistry resultSetRegistry;

    @RequestMapping(value={"/rs/{rsId}/next/{n}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultSetResponse getNextResults(@PathVariable(value="rsId") String rsId, @PathVariable(value="n") int n) throws ResultSetException {
        ResultSetListener rs = this.resultSetRegistry.getResultSetById(rsId);
        int start = rs.getCount();
        ArrayList<String> elements = new ArrayList<String>();
        Gson gson = new Gson();
        while (rs.hasNext() && elements.size() < n) {
            elements.add(gson.toJson(rs.next()));
        }
        int from = start;
        int to = rs.getCount();
        boolean end = !rs.hasNext();
        int total = rs.getTotal();
        return new ResultSetResponse(from, to, end, total, elements);
    }

    @RequestMapping(value={"/rs/{rsId}/info"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultSetInfo getRsInfo(@PathVariable(value="rsId") String rsId) throws ResultSetException {
        ResultSetListener rs = this.resultSetRegistry.getResultSetById(rsId);
        return new ResultSetInfo(rsId, rs);
    }
}

