/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset.client;

import eu.dnetlib.rmi.common.ResultSetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractResultSetClientIterator<T>
implements Iterator<T> {
    private static final Log log = LogFactory.getLog(AbstractResultSetClientIterator.class);
    private final Queue<T> buffer = new LinkedList<T>();

    @Override
    public boolean hasNext() {
        if (!this.buffer.isEmpty()) {
            return true;
        }
        try {
            return this.refillBuffer();
        }
        catch (ResultSetException e) {
            log.error((Object)"Error refilling resultSet buffer", (Throwable)e);
            throw new RuntimeException("Error refilling resultSet buffer", e);
        }
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            log.error((Object)"NoSuchElementException");
            throw new NoSuchElementException();
        }
        return this.buffer.poll();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    private boolean refillBuffer() throws ResultSetException {
        List<T> page = this.nextPage();
        if (page == null || page.isEmpty()) {
            return false;
        }
        this.buffer.addAll(page);
        return true;
    }

    protected abstract List<T> nextPage() throws ResultSetException;
}

