package eu.dnetlib.enabling.datasources;

import java.util.Date;
import java.util.List;
import java.util.Map;

import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.rmi.datasource.*;
import org.springframework.beans.factory.annotation.Required;

public class DatasourceManagerServiceImpl extends AbstractBaseService implements DatasourceManagerService {

	//private List<XmlBrowsableField> browsableFields;

	private DnetDatasourceManagerCore datasourceManagerCore;

	@Override
	public boolean addDatasource(final DatasourceDesc ds) throws DatasourceManagerServiceException {
		return datasourceManagerCore.addDatasource(ds);
	}

	@Override
	public boolean deleteDatasource(final String dsId) throws DatasourceManagerServiceException {
		return datasourceManagerCore.deleteDatasource(dsId);
	}

	@Override
	public DatasourceDesc getDatasource(final String dsId) throws DatasourceManagerServiceException {
		return datasourceManagerCore.getDatasource(dsId);
	}

	@Override
	public List<DatasourceDesc> listAllDatasources() throws DatasourceManagerServiceException {
		return listDatasourcesUsingFilter(null, null, null, null);
	}

	@Override
	public List<DatasourceDesc> listDatasourcesUsingFilter(final String compliance,
			final String contentDescription,
			final String iisProcessingWorkflow,
			final String collectedFrom)
			throws DatasourceManagerServiceException {

		return datasourceManagerCore.listDatasourcesUsingFilter(compliance, contentDescription, iisProcessingWorkflow, collectedFrom);

	}

	@Override
	public boolean updateLevelOfCompliance(final String dsId, final String ifaceId, final String level) throws DatasourceManagerServiceException {
		return datasourceManagerCore.updateLevelOfCompliance(dsId, ifaceId, level);
	}



	@Override
	public boolean updateBaseUrl(final String dsId, final String ifaceId, final String baseUrl) throws DatasourceManagerServiceException {
		return datasourceManagerCore.updateBaseUrl(dsId, ifaceId, baseUrl);
	}



	@Override
	public boolean updateActivationStatus(final String dsId, final String ifaceId, final boolean active) throws DatasourceManagerServiceException {
		return datasourceManagerCore.updateActivationStatus(dsId, ifaceId, active);
	}



	@Override
	public boolean updateContentDescription(final String dsId, final String ifaceId, final String desc) throws DatasourceManagerServiceException {
		return datasourceManagerCore.updateContentDescription(dsId, ifaceId, desc);
	}



	@Override
	public boolean setIisProcessingWorkflow(final String dsId, final String ifaceId, final String wf) throws DatasourceManagerServiceException {
		return datasourceManagerCore.setIisProcessingWorkflow(dsId, ifaceId, wf);
	}

	@Override
	public boolean updateExtraField(final String dsId, final String ifaceId, final String field, final String value, final boolean preserveOriginal)
			throws DatasourceManagerServiceException {
		return datasourceManagerCore.updateExtraField(dsId, ifaceId, field, value, preserveOriginal);
	}



	@Override
	public boolean updateAccessParam(final String dsId, final String ifaceId, final String field, final String value, final boolean preserveOriginal)
			throws DatasourceManagerServiceException {
		return datasourceManagerCore.updateAccessParam(dsId, ifaceId, field, value, preserveOriginal);
	}



	@Override
	public boolean deleteAccessParamOrExtraField(final String dsId, final String ifaceId, final String field) throws DatasourceManagerServiceException {
		return datasourceManagerCore.deleteAccessParamOrExtraField(dsId, ifaceId, field);
	}



	@Override
	public boolean addInterface(final String dsId, final IfaceDesc iface) throws DatasourceManagerServiceException {
		return datasourceManagerCore.addInterface(dsId, iface);
	}

	@Override
	public boolean deleteInterface(final String dsId, final String ifaceId) throws DatasourceManagerServiceException {
		return datasourceManagerCore.deleteInterface(dsId, ifaceId);
	}



	@Override
	public boolean updateSQL(final String dsId, final String sql, final boolean delete) throws DatasourceManagerServiceException {
		return datasourceManagerCore.updateSQL(dsId, sql, delete);
	}

	@Override
	public Date findNextScheduledExecution(final String dsId, final String ifaceId) throws DatasourceManagerServiceException {
		return datasourceManagerCore.findNextScheduledExecution(dsId, ifaceId);
	}



	@Override
	public boolean bulkUpdateApiExtraFields(final String repoId, final String ifaceId, final Map<String, String> fields)
			throws DatasourceManagerServiceException {
		return datasourceManagerCore.bulkUpdateApiExtraFields(repoId, ifaceId, fields);

	}

	@Override
	public boolean bulkUpdateApiAccessParams(final String dsId, final String ifaceId, final Map<String, String> params)
			throws DatasourceManagerServiceException {
		return datasourceManagerCore.bulkUpdateApiAccessParams(dsId, ifaceId, params);
	}



	@Override
	public boolean overrideCompliance(final String dsId, final String ifaceId, final String level) throws DatasourceManagerServiceException {
		return datasourceManagerCore.overrideCompliance(dsId, ifaceId, level);
	}



	@Override
	public List<BrowsableField> listBrowsableFields() throws DatasourceManagerServiceException {
		return datasourceManagerCore.listBrowsableFields();
	}

	@Override
	public List<BrowseTerm> browseField(final String f) throws DatasourceManagerServiceException {
		return datasourceManagerCore.browseField(f);
	}

	@Override
	public List<SearchInterfacesEntry> searchInterface(final String field, final String value) throws DatasourceManagerServiceException {
		return datasourceManagerCore.searchInterface(field, value);
	}



	@Override
	public List<RepositoryMapEntry> getRepositoryMap() throws DatasourceManagerServiceException {
		return datasourceManagerCore.getRepositoryMap();
	}

	@Override
	public List<SimpleDatasourceDesc> simpleListDatasourcesByType(final String type) throws DatasourceManagerServiceException {
		return datasourceManagerCore.simpleListDatasourcesByType(type);
	}

	public DnetDatasourceManagerCore getDatasourceManagerCore() {
		return datasourceManagerCore;
	}

	@Required
	public void setDatasourceManagerCore(final DnetDatasourceManagerCore datasourceManagerCore) {
		this.datasourceManagerCore = datasourceManagerCore;
	}



}
