package eu.dnetlib.enabling.hcm.sn;

import java.util.List;
import javax.annotation.PostConstruct;

import eu.dnetlib.enabling.actions.SubscriptionAction;
import eu.dnetlib.enabling.hcm.HostingContextManagerServiceImpl;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

/**
 * This component takes care of subscribing the SubscriptionAction(s) to interesting events.
 *
 * @author claudio
 *
 */
public class HCMSubscriberImpl implements HCMSubscriber {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(HCMSubscriberImpl.class);

	/**
	 * service locator.
	 */
	@Autowired
	private UniqueServiceLocator serviceLocator;

	/**
	 * hcm
	 */
	private HostingContextManagerServiceImpl hcm;

	/**
	 * subscription actions.
	 */
	@Autowired(required = false)
	private List<SubscriptionAction> actions;

	@PostConstruct
	public void printList() {
		log.info(getActions());
	}

	@Override
	public void subscribeAll() throws SubscriptionException {
		// final String profileId = this.hcm.getProfileId();
		// if (getActions() != null) {
		// for (final SubscriptionAction action : getActions()) {
		// log.info("dynamically subscribing to " + action.getTopicExpression());
		// this.serviceLocator.getService(ISSNService.class).subscribe(profileId, action.getTopicExpression(), 0);
		// }
		// }
	}

	public List<SubscriptionAction> getActions() {
		return this.actions;
	}

	public void setActions(final List<SubscriptionAction> actions) {
		this.actions = actions;
	}

	public HostingContextManagerServiceImpl getHcm() {
		return this.hcm;
	}

	@Required
	public void setHcm(final HostingContextManagerServiceImpl hcm) {
		this.hcm = hcm;
	}

	public UniqueServiceLocator getServiceLocator() {
		return this.serviceLocator;
	}

	public void setServiceLocator(final UniqueServiceLocator serviceLocator) {
		this.serviceLocator = serviceLocator;
	}

}
