package eu.dnetlib.enabling.resultset;

import javax.xml.bind.annotation.XmlRootElement;

import eu.dnetlib.enabling.resultset.listener.ResultSetListener;

@XmlRootElement
public class ResultSetInfo {

	private String id;
	private int cursor = -1;
	private int total = -1;
	private boolean inaccurate = false;

	public ResultSetInfo() {}

	public ResultSetInfo(final String id, final ResultSetListener<?> listener) {
		this.id = id;
		this.cursor = listener.getCount();
		this.total = listener.getTotal();
		this.inaccurate = listener.getCount() < 0 || listener.getTotal() < 0 || listener.getTotal() < listener.getCount();
	}

	public ResultSetInfo(final String id, final int cursor, final int total, final boolean inaccurate) {
		this.id = id;
		this.cursor = cursor;
		this.total = total;
		this.inaccurate = inaccurate;
	}

	public String getId() {
		return this.id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public int getTotal() {
		return this.total;
	}

	public void setTotal(final int total) {
		this.total = total;
	}

	public int getCursor() {
		return this.cursor;
	}

	public void setCursor(final int cursor) {
		this.cursor = cursor;
	}

	public boolean isInaccurate() {
		return this.inaccurate;
	}

	public void setInaccurate(final boolean inaccurate) {
		this.inaccurate = inaccurate;
	}

}
