package eu.dnetlib.enabling.hcm;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import eu.dnetlib.rmi.enabling.HostingContextManagerService;

/**
 * CNR HostingContextManagerService implementation. Will conflict with NKUA! yes this is ok.
 *
 * @author marko
 *
 */
public class HostingContextManagerServiceImpl extends AbstractBaseService implements HostingContextManagerService {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(HostingContextManagerServiceImpl.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * notification handler.
	 */
	private NotificationHandler notificationHandler; // NOPMD

	@Override
	public String echo(final String s) {
		return s;
	}

	@Override
	public void notify(final String subscrId, final String topic, final String isId, final String message) {
		// if (log.isDebugEnabled()) {
		// log.debug("---- service got notification ----");
		// log.debug("subscrId: " + subscrId);
		// log.debug("topic " + topic);
		// log.debug("isId " + isId);
		// log.debug("msg: " + message);
		// log.debug("____ now processing the notification ____");
		// }
		// getNotificationHandler().notified(subscrId, topic, isId, message);
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see eu.dnetlib.enabling.tools.AbstractBaseService#start()
	 */
	@Override
	public void start() {
		log.info("starting hosting context manager");
	}

	public NotificationHandler getNotificationHandler() {
		return this.notificationHandler;
	}

	// @Required
	public void setNotificationHandler(final NotificationHandler notificationHandler) {
		this.notificationHandler = notificationHandler;
	}

}
