package eu.dnetlib.enabling.resultset.listener;

import java.util.Collection;
import java.util.Iterator;

import eu.dnetlib.rmi.common.ResultSetException;

public class IterableResultSetListener<T> implements ResultSetListener<T> {

	private Iterator<T> iter;
	private int count;
	private int total;

	public IterableResultSetListener(final Iterable<T> iter) {
		this(iter.iterator());

		if (iter instanceof Collection) {
			this.total = ((Collection<?>) iter).size();
		}
	}

	public IterableResultSetListener(final Iterator<T> iter) {
		this.iter = iter;
		this.count = 0;
		this.total = -1;
	}

	@Override
	public boolean hasNext() {
		return this.iter.hasNext();
	}

	@Override
	public T next() throws ResultSetException {
		final T res = this.iter.next();
		if (res != null) {
			this.count++;
			return res;
		}
		throw new ResultSetException("Found a null element in resultset");
	}

	@Override
	public int getCount() {
		return this.count;
	}

	@Override
	public int getTotal() {
		return hasNext() ? this.total : this.count;
	}

}
