package eu.dnetlib.enabling.resultset.registry;

import eu.dnetlib.enabling.resultset.listener.ResultSetListener;
import eu.dnetlib.rmi.common.ResultSetException;

/**
 * Instances of ResultSetRegistry manage a set of resultset objects and manage their garbage collection.
 *
 * @author michele
 *
 */
public interface ResultSetRegistry {

	/**
	 * register a resultSetListener
	 *
	 * @param listener
	 *            a resultsetListener object
	 * @return the resultset id
	 */
	String registerResultSet(ResultSetListener<?> listener);

	/**
	 * obtain the resultsetListener with the given id.
	 *
	 * @param rsId
	 *            resultset id
	 * @return the resultsetListener object matching the rsId or null
	 * @throws ResultSetException
	 */
	<T> ResultSetListener<T> getResultSetById(String rsId) throws ResultSetException;

	/**
	 *
	 * @param id
	 * @return
	 */
	boolean contains(String id);
}
