package eu.dnetlib.enabling.resultset;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import eu.dnetlib.enabling.resultset.listener.ResultSetListener;
import eu.dnetlib.enabling.resultset.registry.ResultSetRegistry;
import eu.dnetlib.rmi.common.ResultSetException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ResultSetController {

	@Autowired
	private ResultSetRegistry resultSetRegistry;

	@RequestMapping(value = "/rs/{rsId}/next/{n}", method = RequestMethod.GET)
	public @ResponseBody ResultSetResponse getNextResults(@PathVariable(value = "rsId") final String rsId, @PathVariable(value = "n") final int n)
			throws ResultSetException {
		final ResultSetListener<?> rs = this.resultSetRegistry.getResultSetById(rsId);

		final int start = rs.getCount();

		final List<String> elements = new ArrayList<>();

		final Gson gson = new Gson();
		while (rs.hasNext() && elements.size() < n) {
			elements.add(gson.toJson(rs.next()));
		}

		final int from = start;
		final int to = rs.getCount();
		final boolean end = !rs.hasNext();
		final int total = rs.getTotal();

		return new ResultSetResponse(from, to, end, total, elements);
	}

	@RequestMapping(value = "/rs/{rsId}/info", method = RequestMethod.GET)
	public @ResponseBody ResultSetInfo getRsInfo(@PathVariable(value = "rsId") final String rsId)
			throws ResultSetException {
		final ResultSetListener<?> rs = this.resultSetRegistry.getResultSetById(rsId);
		return new ResultSetInfo(rsId, rs);
	}

}
