package eu.dnetlib.enabling.datasources;

import java.util.Map.Entry;

import eu.dnetlib.rmi.datasource.IfaceDesc;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class IfaceDescToNode {

	public static Element convert(final IfaceDesc iface) throws Exception {

		final Element ifcNode = DocumentHelper.createElement("INTERFACE");
		ifcNode.addAttribute("id", iface.getId());
		ifcNode.addAttribute("label", iface.getTypology() + " (" + iface.getCompliance() + ")");
		ifcNode.addAttribute("compliance", iface.getCompliance());
		ifcNode.addAttribute("typology", iface.getTypology());
		ifcNode.addAttribute("contentDescription", iface.getContentDescription());
		ifcNode.addAttribute("active", Boolean.toString(iface.getActive()));
		ifcNode.addAttribute("removable", Boolean.toString(iface.getRemovable()));

		final Element acProtoNode = ifcNode.addElement("ACCESS_PROTOCOL");

		for (Entry<String, String> e : iface.getAccessParams().entrySet()) {
			acProtoNode.addAttribute(e.getKey(), e.getValue());
		}
		acProtoNode.setText(iface.getAccessProtocol());

		ifcNode.addElement("BASE_URL").setText(iface.getBaseUrl());
		;

		for (Entry<String, String> e : iface.getExtraFields().entrySet()) {
			final Element field = ifcNode.addElement("INTERFACE_EXTRA_FIELD");
			field.addAttribute("name", e.getKey());
			field.setText(e.getValue());
		}

		return ifcNode;
	}
}
