/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset.registry;

import eu.dnetlib.enabling.resultset.listener.ResultSetListener;
import eu.dnetlib.enabling.resultset.registry.ResultSetRegistry;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.rmi.common.ResultSetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ResultSetRegistryImpl
implements ResultSetRegistry {
    private static final String RS_PREFIX = "rs-";
    private long ttl = 600000L;
    private static final Log log = LogFactory.getLog(ResultSetRegistry.class);
    private final Map<String, RsCacheElem> cache = new HashMap<String, RsCacheElem>();

    @Override
    public String registerResultSet(ResultSetListener<?> listener) {
        this.verifyCache();
        String newId = RS_PREFIX + UUID.randomUUID();
        this.cache.put(newId, new RsCacheElem(listener));
        log.debug((Object)("New resultset created: " + newId));
        return newId;
    }

    private void verifyCache() {
        long now = DateUtils.now();
        Set<String> toDelete = this.cache.entrySet().stream().filter(e -> ((RsCacheElem)e.getValue()).isOld(now)).map(e -> (String)e.getKey()).collect(Collectors.toSet());
        if (!toDelete.isEmpty()) {
            log.debug((Object)("The following resultsets are expired: " + toDelete));
        }
        toDelete.forEach(this.cache::remove);
    }

    @Override
    public <T> ResultSetListener<T> getResultSetById(String rsId) throws ResultSetException {
        ResultSetListener<?> rs;
        RsCacheElem elem = this.cache.get(rsId);
        if (elem != null && (rs = elem.getListener()) != null) {
            return rs;
        }
        throw new ResultSetException("Missing resultset with id " + rsId);
    }

    @Override
    public boolean contains(String rsId) {
        return this.cache.get(rsId) != null;
    }

    public long getTtl() {
        return this.ttl;
    }

    @Required
    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    private class RsCacheElem {
        private final ResultSetListener<?> listener;
        private long lastDate = DateUtils.now();

        public RsCacheElem(ResultSetListener<?> listener) {
            this.listener = listener;
        }

        public ResultSetListener<?> getListener() {
            this.lastDate = DateUtils.now();
            return this.listener;
        }

        public boolean isOld(long now) {
            return now - this.lastDate > ResultSetRegistryImpl.this.ttl;
        }
    }
}

