package eu.dnetlib.enabling.datasources;

import java.util.Date;
import java.util.List;
import java.util.Map;

import eu.dnetlib.rmi.datasource.*;

/**
 * Created by sandro on 6/29/16.
 */
public interface DnetDatasourceManagerCore {

	boolean addDatasource(DatasourceDesc datasourceDescription) throws DatasourceManagerServiceException;

	boolean deleteDatasource(final String datasourceIdentifier) throws DatasourceManagerServiceException;

	DatasourceDesc getDatasource(final String datasourceIdentifier) throws DatasourceManagerServiceException;

	List<DatasourceDesc> listDatasourcesUsingFilter(final String compliance, final String contentDescription,
			final String iisProcessingWorkflow,
			final String collectedFrom) throws DatasourceManagerServiceException;

	boolean deleteInterface(final String dsId, final String ifaceId) throws DatasourceManagerServiceException;

	boolean updateLevelOfCompliance(final String dsId, final String interfaceId, final String level) throws DatasourceManagerServiceException;

	boolean updateBaseUrl(final String dsId, final String ifaceId, final String baseUrl) throws DatasourceManagerServiceException;

	boolean updateActivationStatus(final String dsId, final String ifaceId, final boolean active) throws DatasourceManagerServiceException;

	boolean updateContentDescription(final String dsId, final String ifaceId, final String desc) throws DatasourceManagerServiceException;

	boolean setIisProcessingWorkflow(final String dsId, final String ifaceId, final String wf) throws DatasourceManagerServiceException;

	boolean updateExtraField(final String dsId, final String ifaceId, final String field, final String value, final boolean preserveOriginal)
			throws DatasourceManagerServiceException;

	boolean updateAccessParam(final String dsId, final String ifaceId, final String field, final String value, final boolean preserveOriginal)
			throws DatasourceManagerServiceException;

	boolean deleteAccessParamOrExtraField(final String dsId, final String ifaceId, final String field) throws DatasourceManagerServiceException;

	boolean addInterface(final String dsId, final IfaceDesc iface) throws DatasourceManagerServiceException;

	List<DatasourceDesc> listAllDatasources() throws DatasourceManagerServiceException;

	boolean overrideCompliance(String dsId, String ifaceId, String level) throws DatasourceManagerServiceException;

	boolean updateSQL(String dsId, String sql, boolean delete) throws DatasourceManagerServiceException;

	Date findNextScheduledExecution(String dsId, String ifaceId) throws DatasourceManagerServiceException;

	boolean bulkUpdateApiExtraFields(String dsId, String ifaceId, Map<String, String> fields) throws DatasourceManagerServiceException;

	boolean bulkUpdateApiAccessParams(String dsId, String ifaceId, Map<String, String> params) throws DatasourceManagerServiceException;

	List<BrowsableField> listBrowsableFields() throws DatasourceManagerServiceException;

	List<BrowseTerm> browseField(final String field) throws DatasourceManagerServiceException;

	List<SearchInterfacesEntry> searchInterface(final String field, final String value)
			throws DatasourceManagerServiceException;

	List<RepositoryMapEntry> getRepositoryMap() throws DatasourceManagerServiceException;

	List<SimpleDatasourceDesc> simpleListDatasourcesByType(String type) throws DatasourceManagerServiceException;

}
