/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.datasources;

import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.rmi.datasource.DatasourceDesc;
import eu.dnetlib.rmi.datasource.IfaceDesc;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class ProfileToDatasourceDesc
implements Function<String, DatasourceDesc> {
    private static final Log log = LogFactory.getLog(ProfileToDatasourceDesc.class);

    public static DatasourceDesc convert(String profile) throws Exception {
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(profile));
        DatasourceDesc ds = new DatasourceDesc();
        ds.setId(doc.valueOf("//RESOURCE_IDENTIFIER/@value"));
        ds.setDatasourceClass(doc.valueOf("//DATASOURCE_TYPE"));
        ds.setTypology(doc.valueOf("//TYPOLOGY"));
        ds.setOfficialName(doc.valueOf("//OFFICIAL_NAME"));
        ds.setEnglishName(doc.valueOf("//ENGLISH_NAME"));
        ds.setCountryCode(doc.valueOf("//COUNTRY"));
        ds.setLongitude(Double.valueOf(NumberUtils.toDouble((String)doc.valueOf("//LOCATION/LONGITUDE"), (double)0.0)));
        ds.setLatitude(Double.valueOf(NumberUtils.toDouble((String)doc.valueOf("//LOCATION/LATITUDE"), (double)0.0)));
        ds.setTimezone(Double.valueOf(NumberUtils.toDouble((String)doc.valueOf("//LOCATION/TIMEZONE"), (double)0.0)));
        ds.setWebsiteUrl(doc.valueOf("//REPOSITORY_WEBPAGE"));
        ds.setOrganization(doc.valueOf("//REPOSITORY_INSTITUTION"));
        ds.setContactEmail(doc.valueOf("//ADMIN_INFO"));
        for (Object o : doc.selectNodes("//INTERFACES/INTERFACE")) {
            Element n = (Element)o;
            IfaceDesc ifc = new IfaceDesc();
            ifc.setId(n.valueOf("@id"));
            ifc.setCompliance(n.valueOf("@compliance"));
            ifc.setTypology(n.valueOf("@typology"));
            ifc.setContentDescription(n.valueOf("@contentDescription"));
            ifc.setActive(BooleanUtils.toBoolean((String)n.valueOf("@active")));
            ifc.setRemovable(BooleanUtils.toBoolean((String)n.valueOf("@removable")));
            ifc.setBaseUrl(n.valueOf("./BASE_URL"));
            ifc.setAccessProtocol(n.valueOf("./ACCESS_PROTOCOL"));
            for (Object o1 : n.selectNodes("./ACCESS_PROTOCOL/@*")) {
                Node attr = (Node)o1;
                ifc.getAccessParams().put(attr.getName(), attr.getText());
            }
            for (Object o1 : n.selectNodes("./INTERFACE_EXTRA_FIELD")) {
                Node f = (Node)o1;
                ifc.getExtraFields().put(f.valueOf("@name"), f.getText());
            }
            ds.getInterfaces().add(ifc);
        }
        DateUtils dateUtils = new DateUtils();
        for (Object o : doc.selectNodes("//EXTRA_FIELDS/EXTRA_FIELD")) {
            String k = ((Element)o).valueOf("./key").trim();
            String v = ((Element)o).valueOf("./value").trim();
            if (k.equalsIgnoreCase("ACTIVATION_ID")) {
                ds.setActivationId(v);
                continue;
            }
            if (k.equalsIgnoreCase("NamespacePrefix")) {
                ds.setNamespacePrefix(v);
                continue;
            }
            if (k.equalsIgnoreCase("aggregatorName")) {
                ds.setAggregator(v);
                continue;
            }
            if (k.equalsIgnoreCase("dateOfCollection")) {
                ds.setDateOfCollection(dateUtils.parse(v));
                continue;
            }
            if (!k.equalsIgnoreCase("dateOfValidation")) continue;
            ds.setDateOfValidation(dateUtils.parse(v));
        }
        return ds;
    }

    @Override
    public DatasourceDesc apply(String profile) {
        try {
            return ProfileToDatasourceDesc.convert(profile);
        }
        catch (Exception e) {
            log.error((Object)"Error convering profile", (Throwable)e);
            return null;
        }
    }
}

