/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.datasources;

import com.google.common.collect.Sets;
import eu.dnetlib.enabling.datasources.DatasourceDescToProfile;
import eu.dnetlib.enabling.datasources.DnetDatasourceManagerCore;
import eu.dnetlib.enabling.datasources.IfaceDescToNode;
import eu.dnetlib.enabling.datasources.ProfileToDatasourceDesc;
import eu.dnetlib.enabling.datasources.XmlBrowsableField;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.datasource.BrowsableField;
import eu.dnetlib.rmi.datasource.BrowseTerm;
import eu.dnetlib.rmi.datasource.DatasourceDesc;
import eu.dnetlib.rmi.datasource.DatasourceManagerServiceException;
import eu.dnetlib.rmi.datasource.IfaceDesc;
import eu.dnetlib.rmi.datasource.RepositoryMapEntry;
import eu.dnetlib.rmi.datasource.SearchInterfacesEntry;
import eu.dnetlib.rmi.datasource.SimpleDatasourceDesc;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ClassPathResource;

public class DnetDatasourceManagerCoreImpl
implements DnetDatasourceManagerCore {
    private static final Log log = LogFactory.getLog(DnetDatasourceManagerCoreImpl.class);
    private static final String REPOSITORY_RESOURCE_TYPE = "RepositoryServiceResourceType";
    private List<XmlBrowsableField> browsableFields;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private ClassPathResource findReposQueryTmpl = new ClassPathResource("/eu/dnetlib/enabling/datasources/templates/findRepos.xquery.st");
    private ClassPathResource browseRepoApisQueryTmpl = new ClassPathResource("/eu/dnetlib/enabling/datasources/templates/browseRepoApis.xquery.st");
    private ClassPathResource findRepoApisQueryTmpl = new ClassPathResource("/eu/dnetlib/enabling/datasources/templates/findRepoApis.xquery.st");
    private ClassPathResource findReposMapQuery = new ClassPathResource("/eu/dnetlib/enabling/datasources/templates/findReposMap.xquery");
    private ClassPathResource simpleFindReposQueryTmpl = new ClassPathResource("/eu/dnetlib/enabling/datasources/templates/simpleFindRepos.xquery.st");

    @Override
    public boolean addDatasource(DatasourceDesc datasourceDescription) throws DatasourceManagerServiceException {
        try {
            String profile = DatasourceDescToProfile.convert(datasourceDescription);
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).registerProfile(profile);
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error registering profile", (Throwable)e);
            throw new DatasourceManagerServiceException("Error registering profile", (Throwable)e);
        }
    }

    @Override
    public boolean deleteDatasource(String datasourceIdentifier) throws DatasourceManagerServiceException {
        return this._deleteDatasource(this.fixDsId(datasourceIdentifier));
    }

    @Override
    public DatasourceDesc getDatasource(String datasourceIdentifier) throws DatasourceManagerServiceException {
        return this._getDatasource(this.fixDsId(datasourceIdentifier));
    }

    @Override
    public List<DatasourceDesc> listDatasourcesUsingFilter(String compliance, String contentDescription, String iisProcessingWorkflow, String collectedFrom) throws DatasourceManagerServiceException {
        try {
            StringTemplate st = new StringTemplate();
            st.setTemplate(IOUtils.toString((InputStream)this.findReposQueryTmpl.getInputStream()));
            HashMap<String, String> conds = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)compliance)) {
                conds.put("//INTERFACE/@compliance", compliance);
            }
            if (StringUtils.isNotBlank((CharSequence)contentDescription)) {
                conds.put("//INTERFACE/@contentDescription", contentDescription);
            }
            if (StringUtils.isNotBlank((CharSequence)iisProcessingWorkflow)) {
                // empty if block
            }
            if (StringUtils.isNotBlank((CharSequence)collectedFrom)) {
                // empty if block
            }
            if (!conds.isEmpty()) {
                st.setAttribute("conds", conds);
            }
            List list = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(st.toString());
            return list.stream().map(new ProfileToDatasourceDesc()).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error((Object)"Error listing datasources", (Throwable)e);
            throw new DatasourceManagerServiceException("Error listing datasources", (Throwable)e);
        }
    }

    @Override
    public boolean deleteInterface(String dsId, String ifaceId) throws DatasourceManagerServiceException {
        return this._deleteInterface(this.fixDsId(dsId), ifaceId);
    }

    @Override
    public boolean updateLevelOfCompliance(String dsId, String interfaceId, String level) throws DatasourceManagerServiceException {
        return this._updateLevelOfCompliance(this.fixDsId(dsId), interfaceId, level);
    }

    @Override
    public boolean updateBaseUrl(String dsId, String interfaceId, String baseUrl) throws DatasourceManagerServiceException {
        return this._updateBaseUrl(this.fixDsId(dsId), interfaceId, baseUrl);
    }

    @Override
    public boolean updateActivationStatus(String dsId, String ifaceId, boolean active) throws DatasourceManagerServiceException {
        return this._updateActivationStatus(this.fixDsId(dsId), ifaceId, active);
    }

    @Override
    public boolean updateContentDescription(String dsId, String ifaceId, String desc) throws DatasourceManagerServiceException {
        return this._updateContentDescription(this.fixDsId(dsId), ifaceId, desc);
    }

    @Override
    public boolean setIisProcessingWorkflow(String dsId, String ifaceId, String wf) throws DatasourceManagerServiceException {
        throw new DatasourceManagerServiceException("NOT IMPLEMENTED");
    }

    @Override
    public boolean updateExtraField(String dsId, String ifaceId, String field, String value, boolean preserveOriginal) throws DatasourceManagerServiceException {
        return this._updateExtraField(this.fixDsId(dsId), ifaceId, field, value, preserveOriginal);
    }

    @Override
    public boolean updateAccessParam(String dsId, String ifaceId, String field, String value, boolean preserveOriginal) throws DatasourceManagerServiceException {
        return this._updateAccessParam(this.fixDsId(dsId), ifaceId, field, value, preserveOriginal);
    }

    @Override
    public boolean deleteAccessParamOrExtraField(String dsId, String ifaceId, String field) throws DatasourceManagerServiceException {
        return this._deleteAccessParamOrExtraField(this.fixDsId(dsId), ifaceId, field);
    }

    @Override
    public boolean addInterface(String dsId, IfaceDesc iface) throws DatasourceManagerServiceException {
        return this._addInterface(this.fixDsId(dsId), iface);
    }

    @Override
    public List<DatasourceDesc> listAllDatasources() throws DatasourceManagerServiceException {
        return null;
    }

    @Override
    public boolean overrideCompliance(String dsId, String ifaceId, String level) throws DatasourceManagerServiceException {
        return this._overrideCompliance(this.fixDsId(dsId), ifaceId, level);
    }

    @Override
    public boolean updateSQL(String dsId, String sql, boolean delete) throws DatasourceManagerServiceException {
        throw new DatasourceManagerServiceException("NOT IMPLEMENTED");
    }

    @Override
    public Date findNextScheduledExecution(String dsId, String ifaceId) throws DatasourceManagerServiceException {
        return this._findNextScheduledExecution(this.fixDsId(dsId), ifaceId);
    }

    @Override
    public boolean bulkUpdateApiExtraFields(String dsId, String ifaceId, Map<String, String> fields) throws DatasourceManagerServiceException {
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(dsId);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(profile));
            Element iface = (Element)doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']");
            if (iface != null) {
                while (iface.selectNodes("./INTERFACE_EXTRA_FIELD").size() > 0) {
                    iface.selectSingleNode("./INTERFACE_EXTRA_FIELD").detach();
                }
            } else {
                log.error((Object)("Invalid interface: " + ifaceId));
                throw new DatasourceManagerServiceException("Missing interface: " + ifaceId);
            }
            fields.entrySet().forEach(e -> {
                if (e.getValue() != null && !((String)e.getValue()).isEmpty()) {
                    Element field = iface.addElement("INTERFACE_EXTRA_FIELD");
                    field.addAttribute("name", (String)e.getKey());
                    field.addText((String)e.getValue());
                }
            });
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(dsId, doc.asXML(), REPOSITORY_RESOURCE_TYPE);
        }
        catch (Exception e2) {
            log.error((Object)("Error updating API of profile: " + dsId));
            throw new DatasourceManagerServiceException("Error updating API of profile: " + dsId, (Throwable)e2);
        }
        return true;
    }

    @Override
    public boolean bulkUpdateApiAccessParams(String dsId, String ifaceId, Map<String, String> params) throws DatasourceManagerServiceException {
        return this._bulkUpdateApiAccessParams(this.fixDsId(dsId), ifaceId, params);
    }

    @Override
    public List<BrowsableField> listBrowsableFields() throws DatasourceManagerServiceException {
        return this.getBrowsableFields().stream().map(f -> new BrowsableField(f.getId(), f.getLabel())).collect(Collectors.toList());
    }

    @Override
    public List<BrowseTerm> browseField(String f) throws DatasourceManagerServiceException {
        ArrayList<BrowseTerm> list = new ArrayList<BrowseTerm>();
        try {
            XmlBrowsableField field = this.findBrowseField(f, this.getBrowsableFields());
            if (field != null) {
                StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.browseRepoApisQueryTmpl.getInputStream()));
                st.setAttribute("xpath", (Object)field.getXpath());
                Map<String, String> terms = this.fetchVocabularyTerms(field.getVocabulary());
                for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(st.toString())) {
                    String[] arr = s.split("@-@-@");
                    String id = arr[0].trim();
                    int count = NumberUtils.toInt((String)arr[1].trim(), (int)0);
                    list.add(new BrowseTerm(id, this.findLabel(id, terms), count));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error browsing field " + f), (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SearchInterfacesEntry> searchInterface(String field, String value) throws DatasourceManagerServiceException {
        try {
            StringTemplate st = new StringTemplate();
            st.setTemplate(IOUtils.toString((InputStream)this.findRepoApisQueryTmpl.getInputStream()));
            if (field.equalsIgnoreCase("__search__")) {
                st.setAttribute("cond", (Object)("contains(../..//(*|@*)/lower-case(.), '" + StringEscapeUtils.escapeXml11((String)value.toLowerCase()) + "')"));
            } else {
                XmlBrowsableField f = this.findBrowseField(field, this.getBrowsableFields());
                if (f != null) {
                    st.setAttribute("cond", (Object)(f.getXpath() + "='" + StringEscapeUtils.escapeXml11((String)value) + "'"));
                } else {
                    return new ArrayList<SearchInterfacesEntry>();
                }
            }
            String query = st.toString();
            SAXReader reader = new SAXReader();
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query).stream().map(it -> this.convertSearchInterface((String)it, reader)).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error((Object)("Error searching field " + field + " - value: " + value), (Throwable)e);
            return new ArrayList<SearchInterfacesEntry>();
        }
    }

    @Override
    public List<RepositoryMapEntry> getRepositoryMap() throws DatasourceManagerServiceException {
        try {
            SAXReader reader = new SAXReader();
            String query = IOUtils.toString((InputStream)this.findReposMapQuery.getInputStream());
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query).stream().map(it -> this.convertRepositoryMapEntry((String)it, reader)).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error((Object)"Error obtaing repo map entries", (Throwable)e);
            return new ArrayList<RepositoryMapEntry>();
        }
    }

    @Override
    public List<SimpleDatasourceDesc> simpleListDatasourcesByType(String type) throws DatasourceManagerServiceException {
        try {
            ArrayList<SimpleDatasourceDesc> list = new ArrayList<SimpleDatasourceDesc>();
            StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.simpleFindReposQueryTmpl.getInputStream()));
            st.setAttribute("type", (Object)type);
            for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(st.toString())) {
                SimpleDatasourceDesc r = new SimpleDatasourceDesc();
                String[] arr = s.split("@=@");
                r.setId(arr[0].trim());
                r.setName(arr[1].trim());
                r.setOrigId(arr[2].trim());
                r.setApis((Set)Sets.newHashSet((Object[])arr[3].replaceAll("\\s", "").split(",")));
                r.setValid("true".equals(arr[4].trim()));
                r.setTypology(type);
                list.add(r);
            }
            Collections.sort(list);
            return list;
        }
        catch (Exception e) {
            log.error((Object)"Error listing repos", (Throwable)e);
            return new ArrayList<SimpleDatasourceDesc>();
        }
    }

    private boolean _deleteDatasource(String dsId) throws DatasourceManagerServiceException {
        try {
            return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).deleteProfile(dsId);
        }
        catch (ISRegistryException e) {
            log.error((Object)("Error deleting profile " + dsId), (Throwable)e);
            throw new DatasourceManagerServiceException("Error deleting profile " + dsId, (Throwable)e);
        }
    }

    private String fixDsId(String dsId) throws DatasourceManagerServiceException {
        if (dsId.endsWith("_UGVuZGluZ1JlcG9zaXRvcnlSZXNvdXJjZXMvUmVwb3NpdG9yeVNlcnZpY2VSZXNvdXJjZVR5cGU=") || dsId.endsWith("_UmVwb3NpdG9yeVNlcnZpY2VSZXNvdXJjZXMvUmVwb3NpdG9yeVNlcnZpY2VSZXNvdXJjZVR5cGU=")) {
            return dsId;
        }
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType','/db/DRIVER/PendingRepositoryResources/RepositoryServiceResourceType') where $x//DATASOURCE_ORIGINAL_ID = '" + dsId + "' return $x//RESOURCE_IDENTIFIER/@value/string()");
        }
        catch (Exception e) {
            throw new DatasourceManagerServiceException("Invalid id: " + dsId, (Throwable)e);
        }
    }

    private DatasourceDesc _getDatasource(String dsId) throws DatasourceManagerServiceException {
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(dsId);
            return ProfileToDatasourceDesc.convert(profile);
        }
        catch (Exception e) {
            log.error((Object)("Error accessing profile " + dsId), (Throwable)e);
            throw new DatasourceManagerServiceException("Error accessing profile " + dsId, (Throwable)e);
        }
    }

    private boolean _updateLevelOfCompliance(String dsId, String ifaceId, String level) throws DatasourceManagerServiceException {
        try {
            return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfileNode(dsId, "//INTERFACE[@id = '" + ifaceId + "']/@compliance", "'" + level + "'");
        }
        catch (Exception e) {
            log.error((Object)("Error updating profile: " + dsId), (Throwable)e);
            throw new DatasourceManagerServiceException("Error updating profile: " + dsId, (Throwable)e);
        }
    }

    private boolean _updateBaseUrl(String dsId, String interfaceId, String baseUrl) throws DatasourceManagerServiceException {
        try {
            return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfileNode(dsId, "//INTERFACE[@id = '" + interfaceId + "']/BASE_URL", "<BASE_URL>" + baseUrl + "</BASE_URL>");
        }
        catch (Exception e) {
            log.error((Object)("Error updating profile: " + dsId), (Throwable)e);
            throw new DatasourceManagerServiceException("Error updating profile: " + dsId, (Throwable)e);
        }
    }

    private boolean _updateActivationStatus(String dsId, String interfaceId, boolean active) throws DatasourceManagerServiceException {
        try {
            return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfileNode(dsId, "//INTERFACE[@id = '" + interfaceId + "']/@active", "'" + active + "'");
        }
        catch (Exception e) {
            log.error((Object)("Error updating profile: " + dsId), (Throwable)e);
            throw new DatasourceManagerServiceException("Error updating profile: " + dsId, (Throwable)e);
        }
    }

    private boolean _updateContentDescription(String dsId, String ifaceId, String desc) throws DatasourceManagerServiceException {
        try {
            return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfileNode(dsId, "//INTERFACE[@id = '" + ifaceId + "']/@contentDescription", "'" + desc + "'");
        }
        catch (Exception e) {
            log.error((Object)("Error updating profile: " + dsId), (Throwable)e);
            throw new DatasourceManagerServiceException("Error updating profile: " + dsId, (Throwable)e);
        }
    }

    private boolean _updateExtraField(String dsId, String ifaceId, String field, String value, boolean preserveOriginal) throws DatasourceManagerServiceException {
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(dsId);
            Document doc = new SAXReader().read((Reader)new StringReader(profile));
            Node ifcNode = doc.selectSingleNode("//INTERFACE[@id = '" + ifaceId + "']");
            Node node = ifcNode.selectSingleNode("./INTERFACE_EXTRA_FIELD[@name = '" + field + "']");
            if (node != null) {
                node.setText(value);
            } else {
                Element e = ((Element)ifcNode).addElement("INTERFACE_EXTRA_FIELD");
                e.addAttribute("name", field);
                e.setText(value);
            }
            return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(dsId, doc.asXML(), REPOSITORY_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating profile: " + dsId), (Throwable)e);
            throw new DatasourceManagerServiceException("Error updating profile: " + dsId, (Throwable)e);
        }
    }

    private boolean _updateAccessParam(String dsId, String ifaceId, String field, String value, boolean preserveOriginal) throws DatasourceManagerServiceException {
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(dsId);
            Document doc = new SAXReader().read((Reader)new StringReader(profile));
            Node node = doc.selectSingleNode("//INTERFACE[@id = '" + ifaceId + "']/ACCESS_PROTOCOL");
            ((Element)node).addAttribute(field, value);
            return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(dsId, doc.asXML(), REPOSITORY_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating profile: " + dsId), (Throwable)e);
            throw new DatasourceManagerServiceException("Error updating profile: " + dsId, (Throwable)e);
        }
    }

    private boolean _deleteAccessParamOrExtraField(String dsId, String ifaceId, String field) throws DatasourceManagerServiceException {
        try {
            Node ap;
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(dsId);
            Document doc = new SAXReader().read((Reader)new StringReader(profile));
            Node ef = doc.selectSingleNode("//INTERFACE[@id = '" + ifaceId + "']/INTERFACE_EXTRA_FIELD[@name = '" + field + "']");
            if (ef != null) {
                ef.detach();
            }
            if ((ap = doc.selectSingleNode("//INTERFACE[@id = '" + ifaceId + "']/ACCESS_PROTOCOL/@" + field)) != null) {
                ap.detach();
            }
            return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(dsId, doc.asXML(), REPOSITORY_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating profile: " + dsId), (Throwable)e);
            throw new DatasourceManagerServiceException("Error updating profile: " + dsId, (Throwable)e);
        }
    }

    private boolean _addInterface(String dsId, IfaceDesc iface) throws DatasourceManagerServiceException {
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(dsId);
            Document doc = new SAXReader().read((Reader)new StringReader(profile));
            Node node = doc.selectSingleNode("//INTERFACE[@id = '" + iface.getId() + "']");
            if (node != null) {
                node.detach();
            }
            ((Element)doc.selectSingleNode("//INTERFACES")).add(IfaceDescToNode.convert(iface));
            return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(dsId, doc.asXML(), REPOSITORY_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating profile: " + dsId), (Throwable)e);
            throw new DatasourceManagerServiceException("Error updating profile: " + dsId, (Throwable)e);
        }
    }

    private boolean _deleteInterface(String dsId, String ifaceId) throws DatasourceManagerServiceException {
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(dsId);
            Document doc = new SAXReader().read((Reader)new StringReader(profile));
            Node node = doc.selectSingleNode("//INTERFACE[@id = '" + ifaceId + "']");
            if (node != null) {
                node.detach();
            }
            return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(dsId, doc.asXML(), REPOSITORY_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating profile: " + dsId), (Throwable)e);
            throw new DatasourceManagerServiceException("Error updating profile: " + dsId, (Throwable)e);
        }
    }

    private Date _findNextScheduledExecution(String dsId, String ifaceId) throws DatasourceManagerServiceException {
        String xquery = "/*[.//DATAPROVIDER/@interface='" + ifaceId + "' and .//SCHEDULING/@enabled='true']//CRON/text()";
        try {
            String cronExpression = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
            CronExpression cron = new CronExpression(cronExpression);
            return cron.getNextValidTimeAfter(new Date());
        }
        catch (ISLookUpDocumentNotFoundException e) {
            return null;
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error in xquery: " + xquery), (Throwable)e);
            throw new DatasourceManagerServiceException("Error in xquery: " + xquery, (Throwable)e);
        }
        catch (ParseException e) {
            log.error((Object)"Error parsing cron expression", (Throwable)e);
            throw new DatasourceManagerServiceException("Error parsing cron expression", (Throwable)e);
        }
    }

    private boolean _bulkUpdateApiAccessParams(String repoId, String ifaceId, Map<String, String> params) throws DatasourceManagerServiceException {
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(repoId);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(profile));
            Element accessNode = (Element)doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']/ACCESS_PROTOCOL");
            if (accessNode != null) {
                while (accessNode.attributes().size() > 0) {
                    accessNode.selectSingleNode("@*").detach();
                }
                for (Map.Entry<String, String> e : params.entrySet()) {
                    if (e.getValue() == null || e.getValue().isEmpty()) continue;
                    if (e.getKey().equalsIgnoreCase("baseUrl")) {
                        doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']/BASE_URL").setText(e.getValue());
                        continue;
                    }
                    accessNode.addAttribute(e.getKey(), e.getValue());
                }
            } else {
                log.error((Object)("Invalid interface: " + ifaceId));
                throw new DatasourceManagerServiceException("Missing interface: " + ifaceId);
            }
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(repoId, doc.asXML(), REPOSITORY_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating API of profile: " + repoId));
            throw new DatasourceManagerServiceException("Error updating API of profile: " + repoId, (Throwable)e);
        }
        return true;
    }

    private boolean _overrideCompliance(String repoId, String ifaceId, String compliance) throws DatasourceManagerServiceException {
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(repoId);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(profile));
            Element iface = (Element)doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']");
            if (iface != null) {
                HashMap<String, String> fields = new HashMap<String, String>();
                if (!StringUtils.isEmpty((CharSequence)compliance)) {
                    fields.put("overriding_compliance", compliance);
                }
                while (iface.selectNodes("./INTERFACE_EXTRA_FIELD").size() > 0) {
                    Node node = iface.selectSingleNode("./INTERFACE_EXTRA_FIELD");
                    String name = node.valueOf("@name");
                    if (!name.equals("overriding_compliance")) {
                        fields.put(node.valueOf("@name"), node.getText());
                    }
                    node.detach();
                }
                for (Map.Entry e : fields.entrySet()) {
                    if (e.getValue() == null || ((String)e.getValue()).isEmpty()) continue;
                    Element field = iface.addElement("INTERFACE_EXTRA_FIELD");
                    field.addAttribute("name", (String)e.getKey());
                    field.addText((String)e.getValue());
                }
            } else {
                log.error((Object)("Invalid interface: " + ifaceId));
                throw new DatasourceManagerServiceException("Missing interface: " + ifaceId);
            }
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(repoId, doc.asXML(), REPOSITORY_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating API of profile: " + repoId));
            throw new DatasourceManagerServiceException("Error updating API of profile: " + repoId, (Throwable)e);
        }
        return true;
    }

    private XmlBrowsableField findBrowseField(String id, List<XmlBrowsableField> browsableFields) {
        for (XmlBrowsableField f : browsableFields) {
            if (!f.getId().equals(id)) continue;
            return f;
        }
        return null;
    }

    public Map<String, String> fetchVocabularyTerms(String voc) throws ISLookUpException {
        String xquery = "for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')[.//VOCABULARY_NAME/@code = '" + voc.trim() + "']//TERM return concat($x/@code, ' @@@ ', $x/@english_name)";
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery)) {
            String[] arr = s.split("@@@");
            map.put(arr[0].trim(), arr[1].trim());
        }
        return map;
    }

    private String findLabel(String code, Map<String, String> terms) {
        return terms.containsKey(code) ? terms.get(code) : code;
    }

    private SearchInterfacesEntry convertSearchInterface(String s, SAXReader reader) {
        SearchInterfacesEntry iface = new SearchInterfacesEntry();
        try {
            Document doc = reader.read((Reader)new StringReader(s));
            String country = doc.valueOf("//REPO/@country");
            iface.setRepoId(doc.valueOf("//REPO/@id"));
            iface.setRepoCountry(StringUtils.isEmpty((CharSequence)country) ? "-" : country.toUpperCase());
            iface.setRepoName(doc.valueOf("//REPO/@name"));
            iface.setRepoPrefix(doc.valueOf("//REPO/@prefix"));
            Node ifcNode = doc.selectSingleNode("//INTERFACE");
            iface.setId(ifcNode.valueOf("./@id"));
            iface.setActive(Boolean.valueOf(ifcNode.valueOf("./@active")).booleanValue());
            iface.setProtocol(ifcNode.valueOf("./ACCESS_PROTOCOL/text()"));
            String overCompliance = ifcNode.valueOf("./INTERFACE_EXTRA_FIELD[@name='overriding_compliance']");
            if (StringUtils.isEmpty((CharSequence)overCompliance)) {
                iface.setCompliance(ifcNode.valueOf("@compliance"));
            } else {
                iface.setCompliance(overCompliance);
            }
            String lastAggregationDate = ifcNode.valueOf("./INTERFACE_EXTRA_FIELD[@name='last_aggregation_date']");
            if (!StringUtils.isEmpty((CharSequence)lastAggregationDate)) {
                iface.setAggrDate(lastAggregationDate);
            } else {
                String lastDownloadDate = ifcNode.valueOf("./INTERFACE_EXTRA_FIELD[@name='last_download_date']");
                if (!StringUtils.isEmpty((CharSequence)lastDownloadDate)) {
                    iface.setAggrDate(lastDownloadDate);
                }
            }
            String lastAggregationTotal = ifcNode.valueOf("./INTERFACE_EXTRA_FIELD[@name='last_aggregation_total']");
            if (StringUtils.isEmpty((CharSequence)lastAggregationTotal)) {
                String lastDownloadTotal = ifcNode.valueOf("./INTERFACE_EXTRA_FIELD[@name='last_download_total']");
                if (StringUtils.isEmpty((CharSequence)lastDownloadTotal)) {
                    iface.setAggrTotal(0);
                } else {
                    iface.setAggrTotal(NumberUtils.toInt((String)lastDownloadTotal, (int)0));
                }
            } else {
                iface.setAggrTotal(NumberUtils.toInt((String)lastAggregationTotal, (int)0));
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return iface;
    }

    private RepositoryMapEntry convertRepositoryMapEntry(String s, SAXReader reader) {
        RepositoryMapEntry r = new RepositoryMapEntry();
        try {
            Document doc = reader.read((Reader)new StringReader(s));
            r.setId(doc.valueOf("//dsId"));
            r.setName(doc.valueOf("//name"));
            r.setLat(Float.parseFloat(doc.valueOf("//lat")));
            r.setLng(Float.parseFloat(doc.valueOf("//lng")));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return r;
    }

    public List<XmlBrowsableField> getBrowsableFields() {
        return this.browsableFields;
    }

    @Required
    public void setBrowsableFields(List<XmlBrowsableField> browsableFields) {
        this.browsableFields = browsableFields;
    }
}

