/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.action;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.index.IndexCollection;
import eu.dnetlib.index.IndexServerDAOMap;
import eu.dnetlib.index.action.AbstractIndexAction;
import eu.dnetlib.index.action.IndexAction;
import eu.dnetlib.rmi.provision.IndexServiceException;
import eu.dnetlib.utils.MetadataReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteIndexAction
extends AbstractIndexAction
implements BlackboardServerAction<IndexAction> {
    private static final Log log = LogFactory.getLog(DeleteIndexAction.class);
    @Autowired
    private IndexServerDAOMap indexServerDAOMap;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws IndexServiceException {
        String dsId = this.getIndexDSId(job);
        if (dsId == null) {
            throw new IndexServiceException("some Blackboard parameter is missing in DELETE message");
        }
        MetadataReference mdRef = this.getMetadataReference(dsId);
        String backendId = this.getBackend(job);
        if (backendId == null) {
            throw new IndexServiceException("No backend identifier information in CREATE message");
        }
        IndexCollection indexCollection = this.indexServerDAOMap.getIndexServerDAO(backendId).getIndexCollection(mdRef);
        if (!indexCollection.deleteIndex(dsId)) {
            throw new IndexServiceException("Error to delete collection the index response for the delete action is not OK");
        }
        if (!indexCollection.commit()) {
            throw new IndexServiceException("Error to delete collection the index response for the delete action is not OK");
        }
        if (!this.serviceTools.deleteIndexDS(dsId)) {
            log.warn((Object)("couldn't delete IndexDS: " + dsId));
        }
        log.info((Object)("\n\nDELETE report:\n- dsId: " + dsId));
        indexCollection.shutdown();
        handler.done(job);
    }
}

