/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.query;

import eu.dnetlib.clients.index.client.AbstractIndexClient;
import eu.dnetlib.clients.index.query.IndexQuery;
import eu.dnetlib.clients.index.query.IndexQueryFactory;
import eu.dnetlib.clients.index.query.Pruner;
import eu.dnetlib.clients.index.query.QueryLanguage;
import eu.dnetlib.cql.lucene.TranslatedQuery;
import eu.dnetlib.index.query.SolrIndexQuery;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolrIndexQueryFactory
extends IndexQueryFactory {
    private static final Log log = LogFactory.getLog(SolrIndexQueryFactory.class);
    private static final String SERVICE_HIGHLIGHT_ENABLE = "service.index.solr.highlight.enable";

    protected IndexQuery newInstance(TranslatedQuery cql, Pruner.Result res, QueryLanguage lang) {
        switch (lang) {
            case CQL: {
                return new SolrIndexQuery(cql, (Map<String, List<String>>)res.getOptionMap());
            }
            case SOLR: {
                return new SolrIndexQuery(res.getNode().toCQL(), (Map<String, List<String>>)res.getOptionMap());
            }
        }
        throw new IllegalArgumentException("invalid query language: " + lang);
    }

    protected IndexQuery setQueryOptions(IndexQuery indexQuery, AbstractIndexClient client) {
        SolrIndexQuery solrQuery = (SolrIndexQuery)indexQuery;
        boolean isHighlightEnabled = Boolean.parseBoolean((String)client.getServiceProperties().get(SERVICE_HIGHLIGHT_ENABLE));
        if (solrQuery.getHighlight() & isHighlightEnabled) {
            solrQuery.setHighlightFragsize(0).setHighlightSnippets(1).setHighlightSimplePre("[hl]").setHighlightSimplePost("[/hl]").addHighlightField("__result").addField("__indexrecordidentifier");
        }
        solrQuery.addField("__result");
        if (solrQuery.getFacetFields() != null) {
            log.debug((Object)("getFacetFields() " + Arrays.asList(solrQuery.getFacetFields())));
            solrQuery.setFacetMinCount(1);
        }
        return solrQuery;
    }
}

