/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.solr.feed;

import eu.dnetlib.clients.index.model.Any;
import eu.dnetlib.clients.index.model.document.IndexDocument;
import eu.dnetlib.clients.index.model.document.Status;
import eu.dnetlib.index.feed.DocumentMapperFactory;
import eu.dnetlib.index.solr.feed.InputDocumentFactory;
import eu.dnetlib.index.solr.feed.ResultTransformer;
import eu.dnetlib.index.solr.model.SolrIndexDocument;
import eu.dnetlib.utils.MetadataReference;
import java.util.Map;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;
import org.springframework.beans.factory.annotation.Required;

public class SolrDocumentMapperFactory
implements DocumentMapperFactory {
    protected static final String DNETRESULT = "result";
    private InputDocumentFactory documentFactory;

    private Function<String, IndexDocument> getRecordMapper(Map<String, Any.ValueType> schema, String dsId, String version) {
        return doc -> {
            SolrIndexDocument indexDocument = new SolrIndexDocument(schema, dsId);
            try {
                indexDocument.setContent(this.documentFactory.parseDocument(version, (String)doc, dsId, DNETRESULT));
            }
            catch (XMLStreamException e) {
                return indexDocument.setMarked();
            }
            indexDocument.setStatus(Status.OK);
            return indexDocument;
        };
    }

    @Override
    public Function<String, IndexDocument> getRecordMapper(Map<String, Any.ValueType> schema, MetadataReference mdRef, String dsId, String version, boolean emptyResult) {
        if (!emptyResult) {
            return this.getRecordMapper(schema, dsId, version);
        }
        return doc -> {
            SolrIndexDocument indexDocument = new SolrIndexDocument(schema, dsId);
            try {
                ResultTransformer transformer = new ResultTransformer(ResultTransformer.Mode.empty){

                    @Override
                    public String apply(String input) {
                        return input;
                    }
                };
                indexDocument.setContent(this.documentFactory.parseDocument(version, (String)doc, dsId, DNETRESULT, transformer));
            }
            catch (XMLStreamException e) {
                return indexDocument.setMarked();
            }
            indexDocument.setStatus(Status.OK);
            return indexDocument;
        };
    }

    public InputDocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    @Required
    public void setDocumentFactory(InputDocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }
}

