/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.actions;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.oai.actions.AbstractOAIStoreAction;
import eu.dnetlib.oai.mongo.MongoPublisherStore;
import eu.dnetlib.oai.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.oai.utils.OAIParameterNames;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EnsureIndexesAction
extends AbstractOAIStoreAction {
    private static final Log log = LogFactory.getLog(EnsureIndexesAction.class);
    @Autowired
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        try {
            String storeId = (String)job.getParameters().get(OAIParameterNames.OAI_COLLECTON);
            String dbName = (String)job.getParameters().get(OAIParameterNames.OAI_DB);
            if (StringUtils.isBlank((CharSequence)storeId)) {
                log.info((Object)"Ensuring index on all OAI store");
                this.mongoPublisherStoreDAO.ensureIndex(dbName);
            } else {
                log.info((Object)("Ensuring index on " + storeId + " only"));
                MongoPublisherStore store = this.mongoPublisherStoreDAO.getStore(storeId, dbName);
                store.ensureIndices();
            }
            handler.done(job);
        }
        catch (Exception e) {
            handler.failed(job, (Throwable)e);
        }
    }

    public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
        return this.mongoPublisherStoreDAO;
    }

    public void setMongoPublisherStoreDAO(MongoPublisherStoreDAO mongoPublisherStoreDAO) {
        this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
    }
}

