/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.info;

import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;

public class RecordInfo {
    private String prefix = "";
    private String identifier = "";
    private Date datestamp = null;
    private Set<String> setspecs = Sets.newHashSet();
    private String metadata = "";
    private String internalId = "";
    private boolean deleted;
    private String provenance = "";

    public RecordInfo() {
    }

    public RecordInfo(String prefix, String identifier, Date datestamp, String setspec, String metadata, boolean deleted) {
        this(prefix, identifier, datestamp, Sets.newHashSet((Object[])new String[]{setspec}), metadata, deleted);
    }

    public RecordInfo(String prefix, String identifier, Date datestamp, Set<String> setspecs, String metadata, boolean deleted) {
        this.prefix = prefix;
        this.identifier = identifier;
        this.datestamp = datestamp;
        this.setspecs = setspecs;
        this.metadata = metadata;
        this.deleted = deleted;
    }

    public boolean addSetspec(String setspec) {
        if (!this.setspecs.contains(setspec)) {
            this.setspecs.add(setspec);
            return true;
        }
        return false;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Date getDatestamp() {
        return this.datestamp;
    }

    public void setDatestamp(Date datestamp) {
        this.datestamp = datestamp;
    }

    public Set<String> getSetspecs() {
        return this.setspecs;
    }

    public void setSetspecs(Set<String> setspecs) {
        this.setspecs = setspecs;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getNormalizedDatestamp() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = formatter.format(this.datestamp);
        return date.replace("+0000", "Z");
    }

    public String getInternalId() {
        return this.internalId;
    }

    public void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getProvenance() {
        return this.provenance;
    }

    public void setProvenance(String provenance) {
        this.provenance = provenance;
    }
}

