package eu.dnetlib.index.actors;

import akka.actor.ActorSystem;
import akka.actor.TypedActor;
import akka.actor.TypedProps;
import akka.japi.Creator;
import eu.dnetlib.clients.index.utils.ServiceTools;
import eu.dnetlib.index.IndexServerDAOMap;
import eu.dnetlib.cql.CqlTranslator;
import eu.dnetlib.miscutils.factory.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

// TODO: Auto-generated Javadoc
// TODO springify actor parameter with a prototype bean

/**
 * A factory for creating IndexFeedActor objects.
 */
public class IndexFeedActorFactory implements Factory<IndexFeedActor> {

	/**
	 * The index server dao map.
	 */
	private IndexServerDAOMap indexServerDAOMap;

	/**
	 * The service tools.
	 */
	@Autowired
	private ServiceTools serviceTools;

	/**
	 * The actor system.
	 */
	private ActorSystem actorSystem;

	/**
	 * CqlTranslator.
	 */
	@Autowired
	private CqlTranslator translator;

	/**
	 * {@inheritDoc}
	 *
	 * @see Factory#newInstance()
	 */
	@Override
	public IndexFeedActor newInstance() {
		return TypedActor.get(getActorSystem()).typedActorOf(new TypedProps<>(IndexFeedActor.class, (Creator<IndexFeedActorImpl>) () ->
				new IndexFeedActorImpl(getIndexServerDAOMap(), getServiceTools(), translator)));
	}

	/**
	 * Gets the service tools.
	 *
	 * @return the service tools
	 */
	public ServiceTools getServiceTools() {
		return serviceTools;
	}

	/**
	 * Sets the service tools.
	 *
	 * @param serviceTools the new service tools
	 */
	public void setServiceTools(final ServiceTools serviceTools) {
		this.serviceTools = serviceTools;
	}

	/**
	 * Gets the actor system.
	 *
	 * @return the actor system
	 */
	public ActorSystem getActorSystem() {
		return actorSystem;
	}

	/**
	 * Sets the actor system.
	 *
	 * @param actorSystem the new actor system
	 */
	@Required
	public void setActorSystem(final ActorSystem actorSystem) {
		this.actorSystem = actorSystem;
	}

	/**
	 * Gets the index server dao map.
	 *
	 * @return the indexServerDAOMap
	 */
	public IndexServerDAOMap getIndexServerDAOMap() {
		return indexServerDAOMap;
	}

	/**
	 * Sets the index server dao map.
	 *
	 * @param indexServerDAOMap the indexServerDAOMap to set
	 */
	@Required
	public void setIndexServerDAOMap(final IndexServerDAOMap indexServerDAOMap) {
		this.indexServerDAOMap = indexServerDAOMap;
	}

}
