/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.actions;

import com.google.common.collect.Iterables;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.oai.actions.AbstractOAIStoreAction;
import eu.dnetlib.oai.sync.OAIStoreSynchronizer;
import eu.dnetlib.oai.utils.OAIParameterNames;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.utils.MetadataReference;
import eu.dnetlib.utils.MetadataReferenceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SyncAction
extends AbstractOAIStoreAction {
    private static final Log log = LogFactory.getLog(SyncAction.class);
    Resource dmfXsltResource = new ClassPathResource("/eu/dnetlib/oai/xslt/addDMFBlock.xslt");
    @Autowired
    private OAIStoreSynchronizer synchronizer;
    @Autowired
    private ResultSetClient resultSetClient;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Job parameters:");
            job.getParameters().forEach((k, v) -> log.debug((Object)("Name : " + k + " Value : " + v)));
        }
        String epr = (String)job.getParameters().get(OAIParameterNames.OAI_SYNC_EPR);
        String recordSource = (String)job.getParameters().get(OAIParameterNames.OAI_SOURCE);
        boolean alwaysNewRecord = Boolean.valueOf((String)job.getParameters().get(OAIParameterNames.OAI_ALWAYS_NEW_RECORD));
        String dbName = (String)job.getParameters().get(OAIParameterNames.OAI_DB);
        String collectionName = (String)job.getParameters().get(OAIParameterNames.OAI_COLLECTON);
        MetadataReference mdRef = MetadataReferenceFactory.decode((String)collectionName, (String)"-");
        ResultSet rs = ResultSet.fromJson((String)epr);
        log.info((Object)("Synchronizing content for oai on db " + dbName + " for metadata format: " + mdRef));
        Iterable<String> records = this.resultSetClient.iter(rs, String.class);
        if (mdRef.getFormat().equalsIgnoreCase("DMF") || mdRef.getFormat().equalsIgnoreCase("PMF")) {
            records = this.addDMFBlock(records);
        }
        this.synchronizer.synchronize(records, mdRef, recordSource, dbName, alwaysNewRecord, () -> {
            handler.done(job);
            return null;
        }, () -> {
            handler.failed(job, (Throwable)new Exception("Error during OAI synchronization on db " + dbName));
            return null;
        });
    }

    protected Iterable<String> addDMFBlock(Iterable<String> input) {
        ApplyXslt addDMFBlockXslt = new ApplyXslt(this.dmfXsltResource);
        return Iterables.transform(input, arg_0 -> ((ApplyXslt)addDMFBlockXslt).apply(arg_0));
    }

    public OAIStoreSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public void setSynchronizer(OAIStoreSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }
}

