package eu.dnetlib.oai.info;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

import eu.dnetlib.miscutils.functional.hash.Hashing;
import eu.dnetlib.oai.BadResumptionTokenException;

public class ResumptionTokenImpl implements ResumptionToken {

	/**
	 * Total number of documents.
	 */
	private int nMaxElements;
	/**
	 * Requested metadata prefix.
	 */
	private String metadataPrefix;
	/**
	 * Query to use generate the requested records.
	 */
	private String query;

	/**
	 * Number of already read records.
	 */
	private int nRead;

	/**
	 * objIdentifier of the last read document.
	 */
	private String lastObjIdentifier;

	/**
	 * Requested set. Optional.
	 */
	private String requestedSet = "";

	private boolean hasDateRange = false;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String serialize() {
		final String escapedQuery = StringEscapeUtils.escapeXml11(query);
		final List<String> info =
				Arrays.asList("" + nMaxElements, metadataPrefix, escapedQuery, "" + nRead, lastObjIdentifier, "" + hasDateRange, requestedSet);

		String s = StringUtils.join(info, "|");

		while ((s.length() % 3) != 0) {
			s += " "; // If the length is multiple of 3 the base64 does not contain the padding chars (=)
		}

		return Hashing.encodeBase64(s);
	}

	/**
	 * {@inheritDoc}
	 *
	 * @throws BadResumptionTokenException
	 */
	@Override
	public void deserialize(final String token) throws BadResumptionTokenException {
		final String[] info = Hashing.decodeBase64(token).trim().split("\\|");
		if (info.length < 6) { throw new BadResumptionTokenException(token); }
		nMaxElements = Integer.parseInt(info[0]);
		metadataPrefix = info[1];
		final String unescapedQuery = StringEscapeUtils.unescapeXml(info[2]);
		query = unescapedQuery;
		nRead = Integer.parseInt(info[3]);
		lastObjIdentifier = info[4];
		hasDateRange = Boolean.valueOf(info[5]);
		if (info.length == 7) {
			requestedSet = info[6];
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getnMaxElements() {
		return nMaxElements;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setnMaxElements(final int nMaxElements) {
		this.nMaxElements = nMaxElements;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getMetadataPrefix() {
		return metadataPrefix;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMetadataPrefix(final String metadataPrefix) {
		this.metadataPrefix = metadataPrefix;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getQuery() {
		return query;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setQuery(final String query) {
		this.query = query;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getnRead() {
		return nRead;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setnRead(final int nRead) {
		this.nRead = nRead;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getLastObjIdentifier() {
		return lastObjIdentifier;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setLastObjIdentifier(final String lastObjIdentifier) {
		this.lastObjIdentifier = lastObjIdentifier;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getRequestedSet() {
		return requestedSet;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setRequestedSet(final String requestedSet) {
		this.requestedSet = requestedSet;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean hasDateRange() {
		return hasDateRange;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDateRange(final boolean hasDateRange) {
		this.hasDateRange = hasDateRange;
	}

	@Override
	public String toString() {
		return "ResumptionTokenImpl [nMaxElements=" + nMaxElements + ", metadataPrefix=" + metadataPrefix + ", query=" + query + ", nRead=" + nRead
				+ ", lastObjIdentifier=" + lastObjIdentifier + ", hasDateRange=" + hasDateRange + ", requestedSet=" + requestedSet + "]";
	}

}
