package eu.dnetlib.oai.actions;

import com.google.common.collect.Iterables;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.oai.sync.OAIStoreSynchronizer;
import eu.dnetlib.oai.utils.OAIParameterNames;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.utils.MetadataReference;
import eu.dnetlib.utils.MetadataReferenceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;

public class SyncAction extends AbstractOAIStoreAction {

	private static final Log log = LogFactory.getLog(SyncAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	org.springframework.core.io.Resource dmfXsltResource = new ClassPathResource("/eu/dnetlib/oai/xslt/addDMFBlock.xslt");
	@Autowired
	private OAIStoreSynchronizer synchronizer;
	@Autowired
	private ResultSetClient resultSetClient;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		if(log.isDebugEnabled()) {
			log.debug("Job parameters:");
			job.getParameters().forEach((k, v) -> log.debug("Name : " + k + " Value : " + v));
		}

		String epr = job.getParameters().get(OAIParameterNames.OAI_SYNC_EPR);
		String recordSource = job.getParameters().get(OAIParameterNames.OAI_SOURCE);
		boolean alwaysNewRecord = Boolean.valueOf(job.getParameters().get(OAIParameterNames.OAI_ALWAYS_NEW_RECORD));
		final String dbName = job.getParameters().get(OAIParameterNames.OAI_DB);

		final String collectionName = job.getParameters().get(OAIParameterNames.OAI_COLLECTON);
		final MetadataReference mdRef = MetadataReferenceFactory.decode(collectionName, MDREF_SEPARATOR);

		final ResultSet<?> rs = ResultSet.fromJson(epr);
		log.info("Synchronizing content for oai on db " + dbName + " for metadata format: " + mdRef);
		Iterable<String> records = resultSetClient.iter(rs, String.class);
		// in case of DMF there is no "hat element" after oai:metadata: we must add it or the OAI-PMH export will only contain the first
		// element inside oai:metadata.
		if (mdRef.getFormat().equalsIgnoreCase("DMF") || mdRef.getFormat().equalsIgnoreCase("PMF")) {
			records = addDMFBlock(records);
		}
		this.synchronizer.synchronize(records, mdRef, recordSource, dbName, alwaysNewRecord, () -> {
			handler.done(job);
			return null;
		}, () -> {
			handler.failed(job, new Exception("Error during OAI synchronization on db " + dbName));
			return null;
		});

	}

	protected Iterable<String> addDMFBlock(final Iterable<String> input) {
		final ApplyXslt addDMFBlockXslt = new ApplyXslt(dmfXsltResource);
		return Iterables.transform(input, addDMFBlockXslt::apply);
	}

	public OAIStoreSynchronizer getSynchronizer() {
		return synchronizer;
	}

	public void setSynchronizer(final OAIStoreSynchronizer synchronizer) {
		this.synchronizer = synchronizer;
	}

}
