package eu.dnetlib.oai.info;

public class SetInfo {

	private String setSpec;
	private String setName;
	private String setDescription;
	private String query;
	private boolean enabled;

	public SetInfo() {
	}

	public SetInfo(final String spec, final String name, final String description, final boolean enabled) {
		this.setSpec = spec;
		this.setName = name;
		this.setDescription = description;
		this.enabled = enabled;
	}

	/**
	 * This is a string-only constructor to be used by the SplittedQueryExecutor, which enables us to create instances of this class
	 * directly from the information in the IS.
	 *
	 * @param spec
	 * @param name
	 * @param description
	 * @param enabled
	 */
	public SetInfo(final String spec, final String name, final String description, final String enabled) {
		this(spec, name, description, Boolean.valueOf(enabled));
	}

	public SetInfo(final String spec, final String name, final String description, final String query, final boolean enabled) {
		this(spec, name, description, enabled);
		this.query = query;
	}

	/**
	 * This is a string-only constructor to be used by the SplittedQueryExecutor, which enables us to create instances of this class
	 * directly from the information in the IS.
	 *
	 * @param spec
	 * @param name
	 * @param description
	 * @param query
	 * @param enabled
	 */
	public SetInfo(final String spec, final String name, final String description, final String query, final String enabled) {
		this(spec, name, description, enabled);
		this.query = query;
	}

	public String getSetSpec() {
		return setSpec;
	}

	public void setSetSpec(final String setSpec) {
		this.setSpec = setSpec;
	}

	public String getSetDescription() {
		return setDescription;
	}

	public void setSetDescription(final String setDescription) {
		this.setDescription = setDescription;
	}

	public String getQuery() {
		return query;
	}

	public void setQuery(final String query) {
		this.query = query;
	}

	public String getSetName() {
		return setName;
	}

	public void setSetName(final String setName) {
		this.setName = setName;
	}

	public boolean isEnabled() {
		return enabled;
	}

	public void setEnabled(final boolean enabled) {
		this.enabled = enabled;
	}

	@Override
	public String toString() {
		return "SetInfo [setSpec=" + setSpec + ", setName=" + setName + ", setDescription=" + setDescription + ", query=" + query + ", enabled=" + enabled
				+ "]";
	}

}
