package eu.dnetlib.index;

import java.util.List;

import eu.dnetlib.clients.index.utils.ServiceTools;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import eu.dnetlib.rmi.provision.IndexService;
import eu.dnetlib.rmi.provision.IndexServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

/**
 * The Class IndexModularService.
 */
public class IndexModularService extends AbstractBaseService implements IndexService {

	/**
	 * The Constant log.
	 */
	private static final Log log = LogFactory.getLog(IndexService.class);

	/**
	 * The notification handler.
	 */
	private NotificationHandler notificationHandler;

	/**
	 * The service tools.
	 */
	@Autowired
	private ServiceTools serviceTools;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void notify(final String subscriptionId, final String topic, final String isId, final String message) {
		log.debug("Notify method is called");
		getNotificationHandler().notified(subscriptionId, topic, isId, message);

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String identify() {
		log.debug("Identify method is called");
		return this.getClass().toString();
	}

	/**
	 * {@inheritDoc}
	 *
	 * @throws IndexServiceException
	 */
	@Override
	public List<String> getListOfIndices() throws IndexServiceException {

		return serviceTools.listDsIds();
	}

	/**
	 * Gets the notification handler.
	 *
	 * @return the notificationHandler
	 */
	public NotificationHandler getNotificationHandler() {
		return notificationHandler;
	}

	/**
	 * Sets the notification handler.
	 *
	 * @param notificationHandler the notificationHandler to set
	 */
	@Required
	public void setNotificationHandler(final NotificationHandler notificationHandler) {
		this.notificationHandler = notificationHandler;
	}

}
