package eu.dnetlib.index.action;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.index.IndexModularService;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * The Class that implements Identify Action.
 */
public class IdentifyAction extends AbstractIndexAction implements BlackboardServerAction<IndexAction> {

	/**
	 * The index service.
	 */
	@Autowired
	private IndexModularService indexService;

	/**
	 * {@inheritDoc}
	 *
	 * @see BlackboardServerAction#execute(BlackboardServerHandler,
	 * BlackboardJob)
	 */
	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		job.getParameters().put(BBParam.SERVICE_ID, indexService.identify());
	}

}
