package eu.dnetlib.oai;

import eu.dnetlib.oai.OAIController.DELETED_SUPPORT;

public class OAIProperties {

	/**
	 * forwarded url header name, default "X-Forwarded-Url".
	 */
	private String forwardedUrlHeaderName = "X-Forwarded-Url";

	/**
	 * optional base url. If present it overrides the X-Forwarded-Url.
	 */
	private String baseUrl;
	private String repoName = "Driver Service for supporting Open Archive Initiative requests";
	private String repoEmail = "artini@isti.cnr.it";
	private String earliestDatestamp = "1970-01-01";
	private DELETED_SUPPORT deletedRecordSupport;
	private String dateGranularity = "YYYY-MM-DD";

	public String getBaseUrl() {
		return this.baseUrl;
	}

	public void setBaseUrl(final String baseUrl) {
		this.baseUrl = baseUrl;
	}

	public String getRepoName() {
		return this.repoName;
	}

	public void setRepoName(final String repoName) {
		this.repoName = repoName;
	}

	public String getRepoEmail() {
		return this.repoEmail;
	}

	public void setRepoEmail(final String repoEmail) {
		this.repoEmail = repoEmail;
	}

	public String getEarliestDatestamp() {
		return this.earliestDatestamp;
	}

	public void setEarliestDatestamp(final String earliestDatestamp) {
		this.earliestDatestamp = earliestDatestamp;
	}

	public String getDeletedRecordSupport() {
		return this.deletedRecordSupport.toString();
	}

	public void setDeletedRecordSupport(final String deletedRecordSupport) {
		this.deletedRecordSupport = DELETED_SUPPORT.valueOf(deletedRecordSupport.trim().toUpperCase());
	}

	public String getDateGranularity() {
		return this.dateGranularity;
	}

	public void setDateGranularity(final String dateGranularity) {
		this.dateGranularity = dateGranularity;
	}

	public String getForwardedUrlHeaderName() {
		return this.forwardedUrlHeaderName;
	}

	public void setForwardedUrlHeaderName(final String forwardedUrlHeaderName) {
		this.forwardedUrlHeaderName = forwardedUrlHeaderName;
	}

}
