/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.action;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.index.IndexServerDAO;
import eu.dnetlib.index.IndexServerDAOMap;
import eu.dnetlib.index.action.AbstractIndexAction;
import eu.dnetlib.index.action.IndexAction;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.provision.IndexServiceException;
import eu.dnetlib.utils.MetadataReference;
import eu.dnetlib.utils.MetadataReferenceFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class RefreshMDFormatAction
extends AbstractIndexAction
implements BlackboardServerAction<IndexAction> {
    private static final Log log = LogFactory.getLog(RefreshMDFormatAction.class);
    private final transient ThreadLocal<SAXReader> domFactory = new ThreadLocal<SAXReader>(){

        @Override
        protected SAXReader initialValue() {
            return new SAXReader();
        }
    };
    @Autowired
    private transient MetadataReferenceFactory mdFactory;
    @Autowired
    private IndexServerDAOMap indexServerDAOMap;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        String profileId = (String)job.getParameters().get("profileId");
        if (profileId == null) {
            handler.failed(job, (Throwable)new IndexServiceException("parameter profile Id missing"));
            return;
        }
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(profileId);
            Document doc = this.parse(profile);
            Node formatNode = doc.selectSingleNode("//CONFIGURATION/NAME/text()");
            if (formatNode != null && !formatNode.asXML().isEmpty()) {
                String format = formatNode.asXML();
                List layouts = doc.selectNodes("//STATUS/LAYOUTS/LAYOUT");
                Node interpretationNode = doc.selectSingleNode("//CONFIGURATION/INTERPRETATION/text()");
                String interpretation = interpretationNode.asXML();
                log.info((Object)("found a change in mdFormat: " + format));
                for (Element element : layouts) {
                    String layout = element.attributeValue("name");
                    MetadataReference mdRef = this.mdFactory.getMetadata(format, layout, interpretation);
                    Document fields = this.parse(element.selectSingleNode("./FIELDS").asXML());
                    List backends = this.serviceTools.getBackendIds(mdRef);
                    if (backends == null || backends.isEmpty()) {
                        log.warn((Object)("There is no backendId in profiles for mdref " + mdRef));
                    }
                    for (String backendId : backends) {
                        IndexServerDAO idxDao = this.indexServerDAOMap.getIndexServerDAO(backendId);
                        if (idxDao == null) {
                            throw new RuntimeException("No index found for the mdformat " + mdRef);
                        }
                        log.info((Object)"Found index DAO which serve this mdFormat");
                        idxDao.updateIndexCollection(mdRef, fields);
                    }
                }
            }
            log.info((Object)"Upload schema completed");
        }
        catch (Exception e) {
            handler.failed(job, (Throwable)new IndexServiceException((Throwable)e));
            return;
        }
        handler.done(job);
    }

    private Document parse(String source) throws DocumentException {
        return this.domFactory.get().read((Reader)new StringReader(source));
    }
}

