/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.actors;

import eu.dnetlib.clients.index.model.document.IndexDocument;
import eu.dnetlib.clients.index.utils.ServiceTools;
import eu.dnetlib.cql.CqlTranslator;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.index.IndexCollection;
import eu.dnetlib.index.IndexServerDAO;
import eu.dnetlib.index.IndexServerDAOMap;
import eu.dnetlib.index.actors.BlackboardActorCallback;
import eu.dnetlib.index.actors.IndexFeedActor;
import eu.dnetlib.index.actors.ResultsetKeepAliveCallback;
import eu.dnetlib.index.feed.DocumentFeeder;
import eu.dnetlib.index.feed.DocumentMapperFactory;
import eu.dnetlib.index.feed.FeedMode;
import eu.dnetlib.index.feed.FeedResult;
import eu.dnetlib.index.utils.IndexDateUtility;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.rmi.provision.IndexServiceException;
import eu.dnetlib.utils.MetadataReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexFeedActorImpl
implements IndexFeedActor {
    private static final Log log = LogFactory.getLog(IndexFeedActorImpl.class);
    private final transient IndexServerDAOMap indexServerDAOMap;
    private final transient ServiceTools serviceTools;
    private final transient ExecutorService threadPool = Executors.newCachedThreadPool();
    private CqlTranslator translator;

    public IndexFeedActorImpl(IndexServerDAOMap indexServerDAOMap, ServiceTools serviceTools, CqlTranslator translator) {
        this.indexServerDAOMap = indexServerDAOMap;
        this.serviceTools = serviceTools;
        this.translator = translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedIndex(String dsId, FeedMode feedMode, Iterable<String> docIterator, ResultsetKeepAliveCallback startCallback, BlackboardActorCallback endCallback, String backendId, boolean emptyResult) {
        IndexCollection indexCollection = null;
        try {
            startCallback.unschedule();
            MetadataReference mdref = this.serviceTools.getMetadataRef(dsId);
            IndexServerDAO serverDAO = this.indexServerDAOMap.getIndexServerDAO(backendId);
            DocumentMapperFactory docMapperFactory = serverDAO.getDocumentMapperFactory();
            String version = DateUtils.getParsedDateField((String)DateUtils.now_ISO8601());
            Function<String, IndexDocument> docMapper = docMapperFactory.getRecordMapper(serverDAO.getSchema(mdref), mdref, dsId, version, emptyResult);
            Iterable<IndexDocument> result = DnetStreamSupport.generateStreamFromIterator(docIterator.iterator()).map(docMapper)::iterator;
            indexCollection = serverDAO.getIndexCollection(mdref);
            FeedResult res = this.threadPool.submit(new DocumentFeeder(indexCollection, result)).get();
            this.cleanMarkedDocuments(indexCollection, dsId);
            if (feedMode.equals((Object)FeedMode.REFRESH)) {
                this.deleteByVersion(indexCollection, dsId, IndexDateUtility.getParsedDateField(version));
            }
            indexCollection.commit();
            indexCollection.shutdown();
            log.info((Object)("FeedResult: " + res.setTimeElapsed(System.currentTimeMillis())));
            endCallback.setJobDone();
        }
        catch (Exception e) {
            endCallback.setJobFailed(e);
            log.error((Object)"feed index job failed", (Throwable)e);
        }
        finally {
            if (indexCollection != null) {
                indexCollection.shutdown();
            }
        }
    }

    private void deleteByVersion(IndexCollection indexCollection, String dsId, String version) throws IndexServiceException {
        String query = String.format("%s:[* TO \"%s\"}", "__dsversion", version);
        indexCollection.deleteByQuery(query, dsId);
    }

    public void cleanMarkedDocuments(IndexCollection indexCollection, String dsId) throws IndexServiceException {
        String query = "__deleted:true ";
        indexCollection.deleteByQuery("__deleted:true ", dsId);
    }
}

