/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.actions;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.oai.actions.AbstractOAIStoreAction;
import eu.dnetlib.oai.mongo.MongoPublisherStore;
import eu.dnetlib.oai.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.oai.utils.OAIParameterNames;
import eu.dnetlib.rmi.provision.OaiPublisherRuntimeException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateOAIIndexAction
extends AbstractOAIStoreAction {
    @Autowired
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        String storeId = (String)job.getParameters().get(OAIParameterNames.OAI_COLLECTON);
        String dbName = (String)job.getParameters().get(OAIParameterNames.OAI_DB);
        String fieldNames = (String)job.getParameters().get(OAIParameterNames.OAI_INDEXES);
        if (StringUtils.isBlank((CharSequence)dbName) || StringUtils.isBlank((CharSequence)storeId) || StringUtils.isBlank((CharSequence)fieldNames)) {
            throw new IllegalArgumentException(String.format("Job parameters %s, %s and %s are mandatory", OAIParameterNames.OAI_DB, OAIParameterNames.OAI_COLLECTON, OAIParameterNames.OAI_INDEXES));
        }
        MongoPublisherStore store = this.mongoPublisherStoreDAO.getStore(storeId, dbName);
        if (store != null) {
            String[] indexFieldList;
            for (String idx : indexFieldList = fieldNames.replaceAll(" ", "").split(";")) {
                String[] fields = idx.split(",");
                store.createCompoundIndex(Arrays.asList(fields));
            }
        } else {
            throw new OaiPublisherRuntimeException("store " + storeId + " does not exist on db " + dbName + ": can't create compound indices");
        }
        handler.done(job);
    }

    public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
        return this.mongoPublisherStoreDAO;
    }

    public void setMongoPublisherStoreDAO(MongoPublisherStoreDAO mongoPublisherStoreDAO) {
        this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
    }
}

