/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.actions;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.oai.actions.AbstractOAIStoreAction;
import eu.dnetlib.oai.sets.OAISetsCounter;
import eu.dnetlib.oai.utils.OAIParameterNames;
import org.springframework.beans.factory.annotation.Autowired;

public class CountSetsAction
extends AbstractOAIStoreAction {
    @Autowired
    private OAISetsCounter setsCounter;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        String configuredOnly = (String)job.getParameters().get(OAIParameterNames.OAI_CONFIGURED_SETS_ONLY);
        String storeId = (String)job.getParameters().get(OAIParameterNames.OAI_COLLECTON);
        String dbName = (String)job.getParameters().get(OAIParameterNames.OAI_DB);
        if (configuredOnly.equalsIgnoreCase("false")) {
            this.executeForAll(storeId, dbName, handler, job);
        } else {
            this.executeForConfiguredSetsOnly(storeId, dbName, handler, job);
        }
    }

    private void executeForAll(String storeId, String dbName, BlackboardServerHandler handler, BlackboardJob job) {
        this.setsCounter.updateCounts(storeId, dbName, () -> {
            handler.done(job);
            return null;
        }, () -> {
            handler.failed(job, (Throwable)new Exception("Error during OAI sets count on db " + dbName));
            return null;
        });
    }

    private void executeForConfiguredSetsOnly(String storeId, String dbName, BlackboardServerHandler handler, BlackboardJob job) {
        this.setsCounter.updateConfigurationCounts(storeId, dbName, () -> {
            handler.done(job);
            return null;
        }, () -> {
            handler.failed(job, (Throwable)new Exception("Error during OAI sets count on db " + dbName));
            return null;
        });
    }

    public OAISetsCounter getSetsCounter() {
        return this.setsCounter;
    }

    public void setSetsCounter(OAISetsCounter setsCounter) {
        this.setsCounter = setsCounter;
    }
}

