package eu.dnetlib.index;

import java.util.Collection;
import java.util.Iterator;

import eu.dnetlib.clients.index.model.document.IndexDocument;
import eu.dnetlib.rmi.provision.IndexServiceException;

/**
 * The Interface IndexCollection.
 */
public interface IndexCollection {

	/**
	 * Adds an input Document to the index.
	 *
	 * @param doc the doc
	 * @return the solr update response
	 * @throws IndexServiceException the index service exception
	 */
	boolean add(final IndexDocument doc) throws IndexServiceException;

	/**
	 * Adds all the documents to the index giving an iterator of input documents.
	 *
	 * @param docs the iterator of input documents
	 * @return the solr update response
	 * @throws IndexServiceException the index service exception
	 */
	boolean addAll(final Iterator<IndexDocument> docs) throws IndexServiceException;

	/**
	 * Adds the all.
	 *
	 * @param docs the docs
	 * @return the update response
	 * @throws IndexServiceException the index service exception
	 */
	boolean addAll(final Collection<IndexDocument> docs) throws IndexServiceException;

	/**
	 * Delete index.
	 *
	 * @param dsId the ds id
	 * @return true, if successful
	 * @throws IndexServiceException the index service exception
	 */
	boolean deleteIndex(final String dsId) throws IndexServiceException;

	/**
	 * Delete data from the index by query.
	 *
	 * @param query the query
	 * @param dsId  the ds id
	 * @return true, if successful
	 * @throws IndexServiceException the index service exception
	 */
	boolean deleteByQuery(final String query, final String dsId) throws IndexServiceException;

	/**
	 * Commit the data.
	 *
	 * @return true, if successful
	 * @throws IndexServiceException the index service exception
	 */
	boolean commit() throws IndexServiceException;

	/**
	 * Releases resources and closes connections.
	 */
	void shutdown();
}
