package eu.dnetlib.index.actors;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.index.action.BBParam;
import eu.dnetlib.rmi.common.ResultSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ResultsetKeepAliveJob implements Job {

	public static final String JOB_NAME = "resultsetKeepaliveJob";
	public static final String JOB_GROUP = "keepalive";
	private static final Log log = LogFactory.getLog(ResultsetKeepAliveJob.class); // NOPMD by marko on 11/24/08 5:02 PM

	private ResultSetClient resultSetClient;

	@Override
	public void execute(final JobExecutionContext context) throws JobExecutionException {

		final String rsEpr = (String) context.getTrigger().getJobDataMap().get(BBParam.RS_EPR);

		ResultSet<?> resultSet = ResultSet.fromJson(rsEpr);
		try {
			log.debug("\n\n keepalive resultset: " + resultSet.getId() + " triggerId: " + context.getTrigger().getCalendarName() + "\n\n");

			// TODO: change to a getRSStatus call, getNumberOfElements could be potentially slow (ticket #1569)
			resultSetClient.info(resultSet);
		} catch (Throwable e) {
			log.warn("couldn't invoke the resultset call to keep-it-alive");
			throw new RuntimeException(e);
		}
	}

	public ResultSetClient getResultSetClient() {
		return resultSetClient;
	}

	public void setResultSetClient(final ResultSetClient resultSetClient) {
		this.resultSetClient = resultSetClient;
	}
}
