/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.sync;

import eu.dnetlib.oai.conf.OAIConfigurationExistReader;
import eu.dnetlib.oai.mongo.MongoPublisherStore;
import eu.dnetlib.oai.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.rmi.provision.OaiPublisherException;
import eu.dnetlib.rmi.provision.OaiPublisherRuntimeException;
import eu.dnetlib.utils.MetadataReference;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OAIStoreSynchronizer {
    private static final Log log = LogFactory.getLog(OAIStoreSynchronizer.class);
    @Autowired
    private OAIConfigurationExistReader configuration;
    @Autowired
    private MongoPublisherStoreDAO publisherStoreDAO;

    public void synchronize(Iterable<String> records, MetadataReference sourceMetadataFormat, String recordSource, String dbName, boolean alwaysNewRecord, Callable<?> callback, Callable<?> failCallback) {
        try {
            log.fatal((Object)("Synchronizing content for source metadata format " + sourceMetadataFormat));
            log.fatal((Object)("Record source: " + recordSource));
            MongoPublisherStore store = this.getStore(sourceMetadataFormat, dbName, alwaysNewRecord);
            int count = store.feed(records, recordSource);
            log.info((Object)("Content synchronized: store " + sourceMetadataFormat + " fed with " + count + " records"));
            this.executeCallback(callback);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.executeCallback(failCallback);
        }
    }

    private MongoPublisherStore getStore(MetadataReference mdRef, String dbName, boolean alwaysNewRecord) {
        this.publisherStoreDAO.setAlwaysNewRecord(alwaysNewRecord);
        MongoPublisherStore store = this.publisherStoreDAO.getStore(mdRef.getFormat(), mdRef.getInterpretation(), mdRef.getLayout(), dbName);
        if (store == null) {
            log.debug((Object)("Creating store for metadata format: \n" + mdRef + " in db: " + dbName));
            try {
                store = this.publisherStoreDAO.createStore(mdRef.getFormat(), mdRef.getInterpretation(), mdRef.getLayout(), dbName);
                log.debug((Object)("Created store with id: " + store.getId()));
            }
            catch (OaiPublisherException e) {
                throw new OaiPublisherRuntimeException((Throwable)e);
            }
        }
        return store;
    }

    protected void executeCallback(Callable<?> callback) {
        if (callback != null) {
            try {
                callback.call();
            }
            catch (Exception e) {
                log.error((Object)"Error executing callback", (Throwable)e);
            }
        }
    }

    public OAIConfigurationExistReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAIConfigurationExistReader configuration) {
        this.configuration = configuration;
    }

    public MongoPublisherStoreDAO getPublisherStoreDAO() {
        return this.publisherStoreDAO;
    }

    public void setPublisherStoreDAO(MongoPublisherStoreDAO publisherStoreDAO) {
        this.publisherStoreDAO = publisherStoreDAO;
    }
}

