package eu.dnetlib.oai.actions;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.oai.sets.OAISetsCounter;
import eu.dnetlib.oai.utils.OAIParameterNames;
import org.springframework.beans.factory.annotation.Autowired;

public class CountSetsAction extends AbstractOAIStoreAction {

	@Autowired
	private OAISetsCounter setsCounter;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		String configuredOnly = job.getParameters().get(OAIParameterNames.OAI_CONFIGURED_SETS_ONLY);
		String storeId = job.getParameters().get(OAIParameterNames.OAI_COLLECTON);
		String dbName = job.getParameters().get(OAIParameterNames.OAI_DB);

		if (configuredOnly.equalsIgnoreCase("false")) {
			this.executeForAll(storeId, dbName, handler, job);
		} else {
			this.executeForConfiguredSetsOnly(storeId, dbName, handler, job);
		}

	}

	private void executeForAll(final String storeId,  final String dbName, final BlackboardServerHandler handler, final BlackboardJob job) {

		this.setsCounter.updateCounts(storeId, dbName, () -> {
			handler.done(job);
			return null;
		}, () -> {
			handler.failed(job, new Exception("Error during OAI sets count on db " + dbName));
			return null;
		});
	}

	private void executeForConfiguredSetsOnly(final String storeId,  final String dbName, final BlackboardServerHandler handler, final BlackboardJob job) {
		this.setsCounter.updateConfigurationCounts(storeId, dbName, () -> {
			handler.done(job);
			return null;
		}, () -> {
			handler.failed(job, new Exception("Error during OAI sets count on db " + dbName));
			return null;
		});
	}

	public OAISetsCounter getSetsCounter() {
		return this.setsCounter;
	}

	public void setSetsCounter(final OAISetsCounter setsCounter) {
		this.setsCounter = setsCounter;
	}
}
