/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.actions;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.oai.actions.AbstractOAIStoreAction;
import eu.dnetlib.oai.mongo.MongoPublisherStore;
import eu.dnetlib.oai.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.oai.utils.OAIParameterNames;
import eu.dnetlib.rmi.provision.OaiPublisherException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateStoreAction
extends AbstractOAIStoreAction {
    private static final Log log = LogFactory.getLog(CreateStoreAction.class);
    @Autowired
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        String mdformat = (String)job.getParameters().get(OAIParameterNames.OAI_FORMAT_NAME);
        String layout = (String)job.getParameters().get(OAIParameterNames.OAI_FORMAT_LAYOUT);
        String interp = (String)job.getParameters().get(OAIParameterNames.OAI_FORMAT_INTERPRETATION);
        String dbName = (String)job.getParameters().get(OAIParameterNames.OAI_DB);
        String collection = (String)job.getParameters().get(OAIParameterNames.OAI_COLLECTON);
        if (this.mongoPublisherStoreDAO.getStore(mdformat, interp, layout, dbName) == null) {
            MongoPublisherStore store = this.mongoPublisherStoreDAO.createStore(mdformat, interp, layout, dbName);
            if (store == null) {
                log.error((Object)"Cannot create MongoPublisherStore");
                handler.failed(job, (Throwable)new OaiPublisherException(String.format("Cannot create OAI store for %s, %s, %s on db %s", mdformat, interp, layout, dbName)));
            }
            log.info((Object)("Created store with id: " + store.getId() + "on db " + dbName + ": \n" + store.toString()));
        } else {
            log.info((Object)("Store " + collection + " already exists on db " + dbName));
        }
        handler.done(job);
    }
}

