/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.conf;

import com.google.common.base.Joiner;
import eu.dnetlib.oai.PublisherField;
import eu.dnetlib.oai.info.SetInfo;
import eu.dnetlib.rmi.provision.MDFInfo;
import eu.dnetlib.utils.MetadataReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OAIConfiguration {
    private Map<String, SetInfo> setsMap;
    private Map<String, MDFInfo> mdFormatsMap;
    private List<PublisherField> fields;
    private List<String> fieldNames;
    private String idScheme;
    private String idNamespace;
    private Set<MetadataReference> sourcesMDF = new HashSet<MetadataReference>();

    public Collection<PublisherField> getFieldsFor(String format, String layout, String interpretation) {
        String mdRef = Joiner.on((String)"-").join((Object)format, (Object)layout, new Object[]{interpretation});
        return this.getFields().stream().filter(theField -> {
            if (theField.getSources() == null) {
                return false;
            }
            return theField.getSources().containsKey((Object)mdRef);
        }).collect(Collectors.toList());
    }

    public Map<String, SetInfo> getSetsMap() {
        return this.setsMap;
    }

    public void setSetsMap(Map<String, SetInfo> setsMap) {
        this.setsMap = setsMap;
    }

    public Map<String, MDFInfo> getMdFormatsMap() {
        return this.mdFormatsMap;
    }

    public void setMdFormatsMap(Map<String, MDFInfo> mdFormatsMap) {
        this.mdFormatsMap = mdFormatsMap;
    }

    public List<PublisherField> getFields() {
        return this.fields;
    }

    public void setFields(List<PublisherField> fields) {
        this.fields = fields;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
    }

    public Set<MetadataReference> getSourcesMDF() {
        return this.sourcesMDF;
    }

    public void setSourcesMDF(Set<MetadataReference> sourcesMDF) {
        this.sourcesMDF = sourcesMDF;
    }

    public String getIdScheme() {
        return this.idScheme;
    }

    public void setIdScheme(String idScheme) {
        this.idScheme = idScheme;
    }

    public String getIdNamespace() {
        return this.idNamespace;
    }

    public void setIdNamespace(String idNamespace) {
        this.idNamespace = idNamespace;
    }
}

