package eu.dnetlib.index.query;

import org.apache.solr.client.solrj.response.QueryResponse;

import eu.dnetlib.clients.index.client.IndexClientException;
import eu.dnetlib.clients.index.query.IndexQueryResponse;
import eu.dnetlib.clients.index.query.QueryResponseFactory;
import eu.dnetlib.clients.index.query.QueryResponseParser;
import eu.dnetlib.utils.MetadataReference;

/**
 * The Class SolrIndexQueryResponseFactory.
 */
public class SolrIndexQueryResponseFactory extends QueryResponseFactory<QueryResponse> {

	/**
	 * {@inheritDoc}
	 * 
	 * @throws IndexClientException
	 *
	 * @see QueryResponseFactory#getQueryResponseParser(IndexQueryResponse,
	 *      MetadataReference)
	 */
	@Override
	public QueryResponseParser getQueryResponseParser(final IndexQueryResponse<QueryResponse> queryRsp, final MetadataReference mdRef)
			throws IndexClientException {

		QueryResponse response = queryRsp.getContextualQueryResponse();
		return new SolrResponseParser(highlightUtils, browseAliases.get(mdRef), returnEmptyFields, includeRanking, response);
	}

}
