package eu.dnetlib.oai.actions;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.oai.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.oai.utils.OAIParameterNames;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DropStoreAction extends AbstractOAIStoreAction {

	private static final Log log = LogFactory.getLog(DropStoreAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private MongoPublisherStoreDAO mongoPublisherStoreDAO;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		String mdformat = job.getParameters().get(OAIParameterNames.OAI_FORMAT_NAME);
		String layout = job.getParameters().get(OAIParameterNames.OAI_FORMAT_LAYOUT);
		String interp = job.getParameters().get(OAIParameterNames.OAI_FORMAT_INTERPRETATION);
		String dbName = job.getParameters().get(OAIParameterNames.OAI_DB);
		String coll = job.getParameters().get(OAIParameterNames.OAI_COLLECTON);
		String set = job.getParameters().get(OAIParameterNames.OAI_SOURCE);

		boolean deleted = false;
		if (StringUtils.isNotBlank(set)) {
			deleted = mongoPublisherStoreDAO.deleteFromStore(mdformat, interp, layout, dbName, set);
		} else {
			deleted = this.mongoPublisherStoreDAO.deleteStore(mdformat, interp, layout, dbName);
		}
		if (deleted) {
			log.info("OAI Deletion succeeded on db " + dbName+" oaistore: "+coll+", for set (all if empty) : "+set);
		} else {
			log.info("Probably the store to delete "+coll+" does not exist. OAI Deletion failed on db " + dbName);
		}
		handler.done(job);
	}
}
