/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.index.IndexServerDAO;
import eu.dnetlib.rmi.provision.IndexServiceException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractBackendDescriptor
implements IndexServerDAO {
    protected Type typeToken = new TypeToken<Map<String, String>>(){}.getType();
    private Map<String, String> serviceProperties;
    private String jsonConfiguration;

    public void init() throws IndexServiceException {
        try {
            this.serviceProperties = (Map)new Gson().fromJson(this.getJsonConfiguration(), this.typeToken);
        }
        catch (Throwable e) {
            throw new IndexServiceException("unable to parse configuration: " + this.jsonConfiguration, e);
        }
    }

    public String getJsonConfiguration() {
        return this.jsonConfiguration;
    }

    @Required
    public void setJsonConfiguration(String jsonConfiguration) {
        this.jsonConfiguration = jsonConfiguration;
    }

    protected URI getEndpointURL() {
        return URI.create(this.getEndpoint().get("address"));
    }

    @Override
    public Map<String, String> getServiceProperties() {
        return this.serviceProperties;
    }

    @Override
    public String getBackendId() {
        return this.getServiceProperties().get("id");
    }

    @Override
    public Map<String, String> getEndpoint() {
        return Maps.filterKeys(this.getServiceProperties(), key -> key.equals("id") || key.equals("address"));
    }
}

